/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._mod.client_sided.events;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableDouble;

@OnlyIn(value=Dist.CLIENT)
public class MouseMovementEvent
extends Event {
    public static final int HIGH_PRIORITY = 0;
    public static final int MED_PRIORITY = 500;
    public static final int LOW_PRIORITY = 1000;
    private final LinkedList<TicketedOperation> sensibilityOperations = Lists.newLinkedList();

    public void operateSensibilityAddition(int priority, double attribution) {
        this.sensibilityOperations.add(new TicketedOperation(priority, sens -> sens + attribution));
    }

    public void operateSensibilityMultiplication(int priority, double factor) {
        this.sensibilityOperations.add(new TicketedOperation(priority, sens -> sens * factor));
    }

    public void operateSensibilityCustom(int priority, Double2DoubleFunction function) {
        if (function != null) {
            this.sensibilityOperations.add(new TicketedOperation(priority, function));
        }
    }

    public double computeResultingSensibility() {
        MutableDouble finalValue = new MutableDouble(1.0);
        this.sensibilityOperations.stream().sorted(Comparator.comparingInt(TicketedOperation::priority)).forEach(op -> finalValue.setValue(op.function.get(finalValue.doubleValue())));
        return finalValue.doubleValue();
    }

    record TicketedOperation(int priority, Double2DoubleFunction function) {
    }
}

