/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._mod.client_sided;

import bottomtextdanny.braincell.mod._mod.client_sided.ChestMaterial;
import bottomtextdanny.braincell.mod.world.block_utilities.ChestMaterialProvider;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public final class MaterialManager {
    private final List<ResourceLocation> deferredChestLocations = Lists.newArrayList();
    private final List<Material> chestMaterials = Lists.newArrayList();

    public void sendListeners() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (event.getAtlas().m_118330_().equals((Object)Sheets.f_110740_)) {
                this.deferredChestLocations.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
            }
        });
    }

    public Material getChestMaterial(ChestMaterialProvider provider, ChestMaterial type) {
        return this.chestMaterials.get(provider.getChestMaterialSlot() + type.ordinal());
    }

    public void deferMaterialsForChest(ChestMaterialProvider chestSpriteProvider) {
        ResourceLocation[] texturePaths = chestSpriteProvider.chestTexturePaths();
        chestSpriteProvider.setChestMaterialSlot(this.chestMaterials.size());
        this.generateChestBit(texturePaths[0]);
        this.generateChestBit(texturePaths[1]);
        this.generateChestBit(texturePaths[2]);
    }

    private void generateChestBit(ResourceLocation chestTexturePath) {
        this.deferredChestLocations.add(chestTexturePath);
        Material material = new Material(Sheets.f_110740_, chestTexturePath);
        this.chestMaterials.add(material);
    }
}

