/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._mod.client_sided;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.BCStaticData;
import bottomtextdanny.braincell.mod._base.opengl.BCClippingHelper;
import bottomtextdanny.braincell.mod._base.opengl.BCFramebuffer;
import bottomtextdanny.braincell.mod._mod.client_sided.BCClientToken;
import bottomtextdanny.braincell.mod.rendering.HandRendering;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;

public final class BackendRenderingHandler {
    private BCFramebuffer worldDepthFramebuffer;
    private Matrix4f projectionMatrix;
    private Matrix4f modelViewMatrix;
    private Matrix4f invertedModelViewMatrix;
    private float terrainFogStart;
    private float terrainFogEnd;
    private float[] terrainFogColor;
    private BCClippingHelper frustum;
    private boolean updatedToCurrentFrame;

    public void postProcessing() {
        Camera info = this.mc().f_91063_.m_109153_();
        GlStateManager.m_84486_((int)36009, (int)this.worldDepthFramebuffer.getId());
        GlStateManager.m_84513_();
        GlStateManager.m_84323_((int)519);
        HandRendering.render(new PoseStack(), info, BCStaticData.partialTick());
        GlStateManager.m_84525_();
        RenderSystem.m_69453_();
        GlStateManager.m_84507_();
        GlStateManager.m_84486_((int)36009, (int)this.mainTarget().f_83920_);
        GlStateManager.m_84486_((int)36008, (int)this.mainTarget().f_83920_);
        Braincell.client().getShaderHandler().postProcessingFrame();
    }

    public void captureWindowModification() {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget fbo = mc.m_91385_();
        this.worldDepthFramebuffer = new BCFramebuffer(fbo.f_83915_, fbo.f_83916_, true);
    }

    public void captureInitialization(float partialTick) {
        if (!this.updatedToCurrentFrame) {
            BCStaticData.setPartialTick(partialTick, new BCClientToken());
            this.updatedToCurrentFrame = true;
        }
    }

    public void setDataOutdated() {
        this.updatedToCurrentFrame = false;
    }

    public void captureRenderInitialInformation(PoseStack matrixStackIn, Matrix4f projectionIn, Camera activeRenderInfo) {
        Vec3 vector3d = activeRenderInfo.m_90583_();
        double d0 = vector3d.m_7096_();
        double d1 = vector3d.m_7098_();
        double d2 = vector3d.m_7094_();
        this.projectionMatrix = projectionIn.m_27658_();
        this.modelViewMatrix = matrixStackIn.m_85850_().m_85861_().m_27658_();
        Matrix4f mat = RenderSystem.m_157192_().m_27658_();
        mat.m_27659_();
        mat.m_27657_();
        mat.m_27644_(this.modelViewMatrix);
        this.invertedModelViewMatrix = mat;
        this.frustum = new BCClippingHelper(matrixStackIn.m_85850_().m_85861_(), projectionIn);
        this.frustum.setCameraPosition(d0, d1, d2);
    }

    public void captureLevelDepth() {
        if (this.worldDepthFramebuffer == null) {
            this.worldDepthFramebuffer = new BCFramebuffer(this.mainTarget().f_83915_, this.mainTarget().f_83916_, true);
        }
        GlStateManager.m_84486_((int)36008, (int)this.mainTarget().f_83920_);
        GlStateManager.m_84486_((int)36009, (int)this.worldDepthFramebuffer.getId());
        GlStateManager.m_84188_((int)0, (int)0, (int)this.mainTarget().f_83915_, (int)this.mainTarget().f_83916_, (int)0, (int)0, (int)this.worldDepthFramebuffer.width, (int)this.worldDepthFramebuffer.height, (int)256, (int)9728);
        GlStateManager.m_84486_((int)36009, (int)this.mainTarget().f_83920_);
    }

    public void captureTerrainFog() {
        this.terrainFogStart = RenderSystem.m_157200_();
        this.terrainFogEnd = RenderSystem.m_157199_();
        this.terrainFogColor = RenderSystem.m_157198_();
    }

    public BCClippingHelper getClipping() {
        return this.frustum;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4f getModelViewMatrix() {
        return this.modelViewMatrix;
    }

    public Matrix4f getInvertedModelViewMatrix() {
        return this.invertedModelViewMatrix;
    }

    public BCFramebuffer getWorldDepthFramebuffer() {
        return this.worldDepthFramebuffer;
    }

    public float getTerrainFogStart() {
        return this.terrainFogStart;
    }

    public float getTerrainFogEnd() {
        return this.terrainFogEnd;
    }

    public float[] getTerrainFogColor() {
        return this.terrainFogColor;
    }

    private Minecraft mc() {
        return Minecraft.m_91087_();
    }

    private RenderTarget mainTarget() {
        return this.mc().m_91385_();
    }
}

