/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.serialization.util;

import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.SimpleSerializer;
import bottomtextdanny.braincell.mod._base.serialization.WorldDataSerializer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class H_WorldDataParser {
    public static <T> void writeDataToPacket(FriendlyByteBuf stream, SerializerMark<T> serializer, T object, Level level) {
        if (serializer instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializer;
            simple.writePacketStream(stream, object);
        } else if (serializer instanceof WorldDataSerializer) {
            WorldDataSerializer worldData = (WorldDataSerializer)serializer;
            worldData.writePacketStream(stream, level, object);
        } else {
            throw H_WorldDataParser.writeUnsupportedSerializerException(serializer.getClass(), serializer.key());
        }
    }

    public static <T> T readDataFromPacket(FriendlyByteBuf stream, SerializerMark<T> serializer, Level level) {
        if (serializer instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializer;
            return simple.readPacketStream(stream);
        }
        if (serializer instanceof WorldDataSerializer) {
            WorldDataSerializer worldData = (WorldDataSerializer)serializer;
            return worldData.readPacketStream(stream, level);
        }
        throw H_WorldDataParser.readUnsupportedSerializerException(serializer.getClass(), serializer.key());
    }

    public static <T> void writeDataToNBT(CompoundTag nbt, SerializerMark<T> serializer, String storageKey, T object, ServerLevel level) {
        if (serializer instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializer;
            simple.writeNBT(nbt, object, storageKey);
        } else if (serializer instanceof WorldDataSerializer) {
            WorldDataSerializer worldData = (WorldDataSerializer)serializer;
            worldData.writeNBT(nbt, object, (Level)level, storageKey);
        } else {
            throw H_WorldDataParser.writeUnsupportedSerializerException(serializer.getClass(), serializer.key());
        }
    }

    @Nullable
    public static <T> T readDataFromNBT(CompoundTag nbt, SerializerMark<T> serializer, String storageKey, ServerLevel level) {
        if (serializer instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializer;
            return simple.readNBT(nbt, storageKey);
        }
        if (serializer instanceof WorldDataSerializer) {
            WorldDataSerializer worldData = (WorldDataSerializer)serializer;
            return worldData.readNBT(nbt, (Level)level, storageKey);
        }
        throw H_WorldDataParser.readUnsupportedSerializerException(serializer.getClass(), serializer.key());
    }

    public static UnsupportedOperationException readUnsupportedSerializerException(Class<? extends SerializerMark> serializerClass, ResourceLocation serializerKey) {
        String message = "Parser can only read world image serializers and simple image serializers, tried to read: " + serializerClass.getSimpleName() + ", for serializer: " + serializerKey.toString() + '.';
        return new UnsupportedOperationException(message);
    }

    public static UnsupportedOperationException writeUnsupportedSerializerException(Class<? extends SerializerMark> serializerClass, ResourceLocation serializerKey) {
        String message = "Parser can only write from world image serializers and simple image serializers, tried to write from: " + serializerClass.getSimpleName() + ", for serializer: " + serializerKey.toString() + '.';
        return new UnsupportedOperationException(message);
    }
}

