/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.serialization.util;

import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.SimpleSerializer;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class H_DataParser {
    public static <T> void writeDataToPacket(PacketWriteData<T> data) {
        SerializerMark serializerMark = data.reference.serializer();
        if (!(serializerMark instanceof SimpleSerializer)) {
            throw H_DataParser.writeUnsupportedSerializerException(data.reference().serializer().getClass(), data.reference.serializer().key());
        }
        SimpleSerializer simple = (SimpleSerializer)serializerMark;
        simple.writePacketStream(data.stream, data.object);
    }

    public static <T> T readDataFromPacket(PacketReadData<T> data) {
        SerializerMark serializerMark = data.reference.serializer();
        if (serializerMark instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializerMark;
            return simple.readPacketStream(data.stream);
        }
        throw H_DataParser.readUnsupportedSerializerException(data.reference().serializer().getClass(), data.reference.serializer().key());
    }

    public static <T> void writeDataToNBT(NBTWriteData<T> data) {
        SerializerMark serializerMark = data.reference.serializer();
        if (!(serializerMark instanceof SimpleSerializer)) {
            throw H_DataParser.writeUnsupportedSerializerException(data.reference().serializer().getClass(), data.reference.serializer().key());
        }
        SimpleSerializer simple = (SimpleSerializer)serializerMark;
        simple.writeNBT(data.nbt, data.object, data.reference.storageKey());
    }

    @Nullable
    public static <T> T readDataFromNBT(NBTReadData<T> data) {
        SerializerMark serializerMark = data.reference.serializer();
        if (serializerMark instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializerMark;
            return simple.readNBT(data.nbt, data.reference.storageKey());
        }
        throw H_DataParser.readUnsupportedSerializerException(data.reference().serializer().getClass(), data.reference.serializer().key());
    }

    public static UnsupportedOperationException readUnsupportedSerializerException(Class<? extends SerializerMark> serializerClass, ResourceLocation serializerKey) {
        String message = "Parser can only read simple image serializers, tried to read: " + serializerClass.getSimpleName() + ", for serializer: " + serializerKey.toString() + '.';
        return new UnsupportedOperationException(message);
    }

    public static UnsupportedOperationException writeUnsupportedSerializerException(Class<? extends SerializerMark> serializerClass, ResourceLocation serializerKey) {
        String message = "Parser can only write from simple image serializers, tried to write from: " + serializerClass.getSimpleName() + ", for serializer: " + serializerKey.toString() + '.';
        return new UnsupportedOperationException(message);
    }

    public record PacketWriteData<T>(FriendlyByteBuf stream, EntityDataReference<T> reference, T object, Level level) {
    }

    public record PacketReadData<T>(FriendlyByteBuf stream, EntityDataReference<T> reference, Level level) {
    }

    public record NBTWriteData<T>(CompoundTag nbt, EntityDataReference<T> reference, T object, ServerLevel level) {
    }

    public record NBTReadData<T>(CompoundTag nbt, EntityDataReference<T> reference, ServerLevel level) {
    }
}

