/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.serialization.builtin;

import bottomtextdanny.braincell.mod._base.serialization.SimpleSerializer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class ParticleOptionsSerializer
implements SimpleSerializer<ParticleOptions> {
    public static final ResourceLocation REF = new ResourceLocation("braincell", "particle_options");

    @Override
    public void writeNBT(CompoundTag nbt, ParticleOptions obj, String storage) {
        nbt.m_128359_(storage, obj.m_5942_());
    }

    @Override
    @Nullable
    public ParticleOptions readNBT(CompoundTag nbt, String storage) {
        if (!nbt.m_128441_(storage)) {
            return null;
        }
        String particleConfig = nbt.m_128461_(storage);
        try {
            return ParticleArgument.m_103944_((StringReader)new StringReader(nbt.m_128461_(storage)));
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn("Couldn't load custom particle {}", (Object)particleConfig, (Object)e);
            return null;
        }
    }

    @Override
    public void writePacketStream(FriendlyByteBuf stream, ParticleOptions obj) {
        stream.writeInt(Registry.f_122829_.m_7447_((Object)obj.m_6012_()));
        obj.m_7711_(stream);
    }

    @Override
    public ParticleOptions readPacketStream(FriendlyByteBuf stream) {
        Optional<ParticleType> particleTypeOp = Optional.ofNullable((ParticleType)Registry.f_122829_.m_7942_(stream.readInt()));
        try {
            return particleTypeOp.isPresent() ? (ParticleOptions)this.readParticleFromStream(stream, particleTypeOp.get()) : null;
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't load custom particle from client", (Throwable)e);
            return null;
        }
    }

    private <T extends ParticleOptions> T readParticleFromStream(FriendlyByteBuf stream, ParticleType<T> type) {
        return (T)type.m_123743_().m_6507_(type, stream);
    }

    @Override
    public ResourceLocation key() {
        return REF;
    }
}

