/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.serialization;

import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.SimpleSerializer;
import bottomtextdanny.braincell.mod._base.serialization.WorldDataSerializer;
import bottomtextdanny.braincell.mod._base.serialization.util.H_WorldDataParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public final class WorldPacketData<T> {
    public final SerializerMark<T> serializer;
    private T objInstance;

    public WorldPacketData(SerializerMark<T> ser, T obj) {
        this.serializer = ser;
        this.objInstance = obj;
    }

    public T get() {
        return this.objInstance;
    }

    public void set(T t) {
        this.objInstance = t;
    }

    public static <E> WorldPacketData<E> of(SerializerMark<E> ser, E obj) {
        return new WorldPacketData<E>(ser, obj);
    }

    public void writeToStream(FriendlyByteBuf stream, Level level) {
        SerializerMark<T> serializerMark = this.serializer;
        if (serializerMark instanceof SimpleSerializer) {
            SimpleSerializer simple = (SimpleSerializer)serializerMark;
            simple.writePacketStream(stream, this.objInstance);
        } else {
            serializerMark = this.serializer;
            if (serializerMark instanceof WorldDataSerializer) {
                WorldDataSerializer entityOriented = (WorldDataSerializer)serializerMark;
                entityOriented.writePacketStream(stream, level, this.objInstance);
            } else {
                throw H_WorldDataParser.writeUnsupportedSerializerException(this.serializer.getClass(), this.serializer.key());
            }
        }
    }

    public SerializerMark<T> getSerializer() {
        return this.serializer;
    }
}

