/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.rendering.ik;

import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.ik.IKConstraint;
import bottomtextdanny.braincell.mod._base.rendering.ik.IKPartData;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class BCIKPart<T> {
    private final BCJoint joint;
    private final Function<T, IKPartData> dataGetter;
    @Nullable
    private IKConstraint constraint;

    public BCIKPart(BCJoint joint, Function<T, IKPartData> dataGetter, IKConstraint ... constraints) {
        this.joint = joint;
        this.dataGetter = dataGetter;
        for (IKConstraint constraint : constraints) {
            this.constraint = this.constraint == null ? constraint : this.constraint.andThen(constraint);
        }
    }

    @Nullable
    public IKConstraint getConstraint() {
        return this.constraint;
    }

    public BCJoint joint() {
        return this.joint;
    }

    public Function<T, IKPartData> dataGetter() {
        return this.dataGetter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BCIKPart that = (BCIKPart)obj;
        return Objects.equals(this.joint, that.joint) && Objects.equals(this.dataGetter, that.dataGetter) && Objects.equals(this.constraint, that.constraint);
    }

    public int hashCode() {
        return Objects.hash(this.joint, this.dataGetter, this.constraint);
    }

    public String toString() {
        return "BCIKPart[joint=" + this.joint + ", dataGetter=" + this.dataGetter + ", constraints=" + this.constraint + "]";
    }
}

