/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.rendering.ik;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.base.Easing;
import bottomtextdanny.braincell.base.matrix.RotationMatrix;
import bottomtextdanny.braincell.mod._base.animation.AnimatableModelComponent;
import bottomtextdanny.braincell.mod._base.animation.PosMutator;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.ModelSectionReseter;
import bottomtextdanny.braincell.mod._base.rendering.ik.BCIKPart;
import bottomtextdanny.braincell.mod._base.rendering.ik.IKConstraint;
import bottomtextdanny.braincell.mod._base.rendering.ik.IKPartData;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public class BCIKHandler<T>
implements ModelSectionReseter,
AnimatableModelComponent<PosMutator> {
    private static final RotationMatrix ROTATOR = new RotationMatrix();
    protected final BCIKPart<T>[] joints;
    protected Vector3f goal = new Vector3f();
    public final int top;

    public BCIKHandler(BCIKPart<T> ... joints) {
        this.joints = joints;
        this.top = this.joints.length - 1;
    }

    public void drag2(T object) {
        IKPartData childData = null;
        Vector3f lgoalVector = null;
        for (int j = 0; j < 100; ++j) {
            for (int i = this.top; i >= 2; --i) {
                BCIKPart<T> current = this.joints[i];
                IKPartData data = current.dataGetter().apply(object);
                lgoalVector = this.goal;
                Vector3f relativePos = this.getLocalPos(object, 0, i);
                Vector3f relativeTopPos = this.getLocalPos(object, i, this.top);
                float hDistToTop = (float)Math.sqrt(BCMath.dot2(relativeTopPos.m_122239_(), relativeTopPos.m_122269_()));
                float hDistToGoal = (float)Math.sqrt(BCMath.dot2(lgoalVector.m_122239_() - relativePos.m_122239_(), lgoalVector.m_122269_() - relativePos.m_122269_()));
                float xDif = BCMath.radianAngleDiff((float)Mth.m_14136_((double)(lgoalVector.m_122260_() - relativePos.m_122260_()), (double)hDistToGoal), (float)Mth.m_14136_((double)relativeTopPos.m_122260_(), (double)hDistToTop));
                if (!Float.isNaN(xDif)) {
                    data.xRot += xDif;
                }
                relativePos = this.getLocalPos(object, 0, i);
                relativeTopPos = this.getLocalPos(object, i, this.top);
                float yDif = BCMath.radianAngleDiff((float)Mth.m_14136_((double)(lgoalVector.m_122269_() - relativePos.m_122269_()), (double)(lgoalVector.m_122239_() - relativePos.m_122239_())), (float)Mth.m_14136_((double)relativeTopPos.m_122269_(), (double)relativeTopPos.m_122239_()));
                if (!Float.isNaN(yDif)) {
                    data.yRot += yDif;
                }
                childData = data;
            }
        }
    }

    public Vector3f rotateToModel(T object, Vector3f vector, int partIndex) {
        float y = 0.0f;
        float x = 0.0f;
        for (int i = 0; i < partIndex; ++i) {
            IKPartData data = this.joints[i].dataGetter().apply(object);
            x += data.xRot;
            y += data.yRot;
        }
        ROTATOR.rotX(x);
        Vector3f rVec = ROTATOR.getTransform(vector);
        ROTATOR.rotY(y);
        ROTATOR.transform(rVec);
        return rVec;
    }

    public Vector3f getLocalPos(T object, int startIndex, int index) {
        float xDelta = 0.0f;
        float yDelta = 0.0f;
        float zDelta = 0.0f;
        float xRot = 0.0f;
        float yRot = 0.0f;
        for (int i = startIndex; i < index + 1; ++i) {
            BCJoint joint = this.joints[i].joint();
            float dist = 0.0f;
            float yCos = Mth.m_14089_((float)yRot);
            float ySin = Mth.m_14031_((float)yRot);
            float xCos = Mth.m_14089_((float)xRot);
            float xSin = Mth.m_14031_((float)xRot);
            if (i - 1 >= 0) {
                IKPartData data = this.joints[i - 1].dataGetter().apply(object);
                xRot = Float.isNaN(data.xRot) ? 0.0f : data.xRot;
                yRot = Float.isNaN(data.yRot) ? 0.0f : data.yRot;
                yCos = Mth.m_14089_((float)yRot);
                ySin = Mth.m_14031_((float)yRot);
                xCos = Mth.m_14089_((float)xRot);
                xSin = Mth.m_14031_((float)xRot);
                dist = (float)Math.sqrt(joint.x * joint.x + joint.y * joint.y + joint.z * joint.z);
            }
            float xDeltaO = xDelta;
            float yDeltaO = yDelta;
            float zDeltaO = zDelta;
            yDelta += -xSin * dist;
            float calcDist = (float)Math.sqrt((xDelta += ySin * xCos * dist) * xDelta + (zDelta += yCos * xCos * dist) * zDelta);
            float f = (float)Math.sqrt(xDeltaO * xDeltaO + zDeltaO * zDeltaO);
        }
        return new Vector3f(xDelta, yDelta, zDelta);
    }

    public Vector3f getLocalTopPos(T object, int index) {
        float xDelta = 0.0f;
        float yDelta = 0.0f;
        float zDelta = 0.0f;
        float xRot = 0.0f;
        float yRot = 0.0f;
        return new Vector3f(xDelta, yDelta, zDelta);
    }

    public void drag(T object) {
        float xGoal = this.goal.m_122239_();
        float yGoal = this.goal.m_122260_();
        float zGoal = this.goal.m_122269_();
        for (int j = 0; j < 1; ++j) {
            for (int i = this.joints.length - 1; i >= 0; --i) {
                BCIKPart<T> current = this.joints[i];
                IKPartData data = current.dataGetter().apply(object);
                if (i + 1 < this.joints.length) {
                    BCIKPart<T> child = this.joints[i + 1];
                    IKPartData childData = child.dataGetter().apply(object);
                    this.dragJoint(i, object, data, current.getConstraint(), childData.x, childData.y, childData.z, child.joint().x, child.joint().y, child.joint().z);
                    continue;
                }
                this.dragJoint(i, object, data, current.getConstraint(), xGoal, yGoal, zGoal, 0.0f, 0.0f, 0.0f);
            }
            IKPartData firstData = this.joints[0].dataGetter().apply(object);
            float dx = firstData.x;
            float dy = firstData.y;
            float dz = firstData.z;
            for (int i = 0; i < this.joints.length; ++i) {
                BCIKPart<T> part = this.joints[i];
                IKPartData data = part.dataGetter().apply(object);
                data.x -= dx;
                data.y -= dy;
                data.z -= dz;
                if (i == this.joints.length - 1) continue;
                BCIKPart<T> child = this.joints[i + 1];
                IKPartData childData = child.dataGetter().apply(object);
                this.dragJoint(i, object, data, part.getConstraint(), childData.x, childData.y, childData.z, child.joint().x, child.joint().y, child.joint().z);
            }
            xGoal = this.goal.m_122239_() + dx;
            yGoal = this.goal.m_122260_() + dy;
            zGoal = this.goal.m_122269_() + dz;
        }
    }

    public void dragJoint(int index, T object, IKPartData data, IKConstraint constraint, float lookX, float lookY, float lookZ, float repoX, float repoY, float repoZ) {
        float dist = (float)Math.sqrt(repoX * repoX + repoY * repoY + repoZ * repoZ);
        this.aimJoint(index, object, data, constraint, lookX, lookY, lookZ);
        float yCos = Mth.m_14089_((float)data.yRot);
        float ySin = Mth.m_14031_((float)data.yRot);
        float xCos = Mth.m_14089_((float)data.xRot);
        float xSin = Mth.m_14031_((float)data.xRot);
        data.x = lookX - ySin * xCos * dist;
        data.y = lookY - -xSin * dist;
        data.z = lookZ - yCos * xCos * dist;
    }

    public void aimJoint(int index, T object, IKPartData data, IKConstraint constraint, float x, float y, float z) {
        boolean negDist = z * z + x * x < 0.0f;
        float horizontalDistance = (float)Math.sqrt(z * z + x * x);
        negDist = data.z * data.z + data.x * data.x < 0.0f;
        float dataHorizontalDistance = (float)Math.sqrt(data.z * data.z + data.x * data.x);
        data.yRot = (float)Mth.m_14136_((double)(-x - data.x), (double)(-z - data.z));
        data.xRot = (float)Mth.m_14136_((double)(-y + data.y), (double)(-horizontalDistance + dataHorizontalDistance));
        data.yRot = (float)Mth.m_14136_((double)(-x - data.x), (double)(-z - data.z));
        data.xRot = (float)Mth.m_14136_((double)(-y + data.y), (double)(-horizontalDistance + dataHorizontalDistance));
    }

    public void setToModel(T object) {
        BCIKPart<T>[] bcikParts = this.joints;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float stackDeltaX = 0.0f;
        float stackDeltaY = 0.0f;
        for (int i = 0; i < bcikParts.length; ++i) {
            BCIKPart<T> joint = bcikParts[i];
            IKPartData data = bcikParts[i].dataGetter().apply(object);
            Vector3f np = null;
            Vector3f p = this.getLocalPos(object, 0, i);
            if (i + 1 < this.joints.length) {
                np = this.getLocalPos(object, 0, i + 1);
            }
            if (i == 1) {
                joint.joint().xRot += data.xRot - stackDeltaX;
                joint.joint().yRot += data.yRot - stackDeltaY;
                stackDeltaX += joint.joint().xRot;
                stackDeltaY += joint.joint().yRot;
                continue;
            }
            joint.joint().xRot += data.xRot;
            joint.joint().yRot += data.yRot;
            stackDeltaX += joint.joint().xRot;
            stackDeltaY += joint.joint().yRot;
            if (i != 2) continue;
            Minecraft.m_91087_().f_91074_.m_108739_("x: " + Mth.m_14177_((float)(57.295776f * data.xRot)) + "  y: " + Mth.m_14177_((float)(57.295776f * data.yRot)));
        }
        this.joints[0].joint().xRot += (float)Math.PI;
        Vector3f finalPos = this.getLocalPos(object, 0, this.top);
    }

    public void set(float x, float y, float z) {
        this.goal.m_122245_(x, y, z);
    }

    public void add(float x, float y, float z) {
        this.goal.m_122272_(x, y, z);
    }

    public float getGoalX() {
        return this.goal.m_122239_();
    }

    public float getGoalY() {
        return this.goal.m_122260_();
    }

    public float getGoalZ() {
        return this.goal.m_122269_();
    }

    @Override
    public String name() {
        return "unknown";
    }

    @Override
    public PosMutator newAnimationData() {
        return new PosMutator();
    }

    @Override
    public void animationTransitionerPrevious(PosMutator previous, PosMutator current, float multiplier, float progression, Map<Easing, Float> easingMap) {
        progression = 1.0f - progression;
        this.goal.m_122272_(progression * previous.getPosX(), progression * previous.getPosY(), progression * previous.getPosZ());
    }

    @Override
    public void animationTransitionerCurrent(PosMutator current, float multiplier, float progression, Map<Easing, Float> easingMap) {
        this.goal.m_122272_(progression * current.getPosX(), progression * current.getPosY(), progression * current.getPosZ());
    }

    @Override
    public void reset(BCModel model) {
        this.goal.m_122245_(0.0f, 0.0f, 0.0f);
    }
}

