/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.rendering.core_modeling;

import bottomtextdanny.braincell.base.Easing;
import bottomtextdanny.braincell.base.matrix.RotationMatrix;
import bottomtextdanny.braincell.mod._base.animation.AnimatableModelComponent;
import bottomtextdanny.braincell.mod._base.animation.JointMutator;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCBox;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCTexturedQuad;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCVertex;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.JointMirroring;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.ModelSectionReseter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BCJoint
implements ModelSectionReseter,
AnimatableModelComponent<JointMutator> {
    private final ObjectList<BCBox> cubeList = new ObjectArrayList();
    private final ObjectList<BCJoint> childModels = new ObjectArrayList();
    private final BCModel model;
    @Nullable
    private BCJoint mirrorJoint;
    @Nullable
    private JointMirroring mirrorType;
    private BCJoint parent;
    private String name;
    public int textureOffsetX;
    public int textureOffsetY;
    private BiConsumer<BCJoint, PoseStack> renderCallback;
    public float defaultAngleX;
    public float defaultAngleY;
    public float defaultAngleZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float defaultSizeX;
    public float defaultSizeY;
    public float defaultSizeZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    private boolean mirror;

    public BCJoint(BCModel model, String name) {
        this(model);
        this.name = name;
    }

    public BCJoint(BCModel model) {
        this.setScaleCore(1.0f, 1.0f, 1.0f);
        model.addReseter(this);
        this.model = model;
        model.addJoint(this);
    }

    public <T extends BCJoint> T callback(BiConsumer<BCJoint, PoseStack> cons) {
        this.renderCallback = cons;
        return (T)this;
    }

    public BCJoint mirror(JointMirroring type) {
        this.mirrorType = type;
        return this;
    }

    public BCJoint mirrorJoint(BCJoint mirroring) {
        this.mirrorJoint = mirroring;
        return this;
    }

    @Override
    public void reset(BCModel model) {
        this.xRot = this.defaultAngleX;
        this.yRot = this.defaultAngleY;
        this.zRot = this.defaultAngleZ;
        this.x = this.defaultOffsetX;
        this.y = this.defaultOffsetY;
        this.z = this.defaultOffsetZ;
        this.scaleX = this.defaultSizeX;
        this.scaleY = this.defaultSizeY;
        this.scaleZ = this.defaultSizeZ;
    }

    public void addChild(BCJoint renderer) {
        this.childModels.add((Object)renderer);
        renderer.parent = this;
    }

    public BCBox getCube(int index) {
        return (BCBox)this.cubeList.get(index);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void setPosCore(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.x = this.defaultOffsetX = rotationPointXIn;
        this.y = this.defaultOffsetY = rotationPointYIn;
        this.z = this.defaultOffsetZ = rotationPointZIn;
    }

    public void setRotationAngleCore(float rotationAngleXIn, float rotationAngleYIn, float rotationAngleZIn) {
        this.xRot = this.defaultAngleX = rotationAngleXIn;
        this.yRot = this.defaultAngleY = rotationAngleYIn;
        this.zRot = this.defaultAngleZ = rotationAngleZIn;
    }

    public void setScaleCore(float x, float y, float z) {
        this.scaleX = this.defaultSizeX = x;
        this.scaleY = this.defaultSizeY = y;
        this.scaleZ = this.defaultSizeZ = z;
    }

    public void setPos(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.x = rotationPointXIn;
        this.y = rotationPointYIn;
        this.z = rotationPointZIn;
    }

    public void setRotationAngle(float rotationAngleXIn, float rotationAngleYIn, float rotationAngleZIn) {
        this.xRot = rotationAngleXIn;
        this.yRot = rotationAngleYIn;
        this.zRot = rotationAngleZIn;
    }

    public void setScale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
    }

    public void addToPos(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.x += rotationPointXIn;
        this.y += rotationPointYIn;
        this.z += rotationPointZIn;
    }

    public void addToRotationAngle(float rotationAngleXIn, float rotationAngleYIn, float rotationAngleZIn) {
        this.xRot += rotationAngleXIn;
        this.yRot += rotationAngleYIn;
        this.zRot += rotationAngleZIn;
    }

    public void addToScale(float x, float y, float z) {
        this.scaleX += x;
        this.scaleY += y;
        this.scaleZ += z;
    }

    public BCJoint uvOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public Boxer makeBox() {
        return new Boxer(this);
    }

    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.visible) {
            matrixStackIn.m_85836_();
            this.translateRotate(matrixStackIn);
            matrixStackIn.m_85841_(this.scaleX, this.scaleY, this.scaleZ);
            if (this.renderCallback != null) {
                this.renderCallback.accept(this, matrixStackIn);
            }
            if (!this.cubeList.isEmpty() || !this.childModels.isEmpty()) {
                this.renderCubes(matrixStackIn.m_85850_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                for (BCJoint modelrenderer : this.childModels) {
                    modelrenderer.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                }
            }
            matrixStackIn.m_85849_();
        }
    }

    private void renderCubes(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Matrix4f matrixPosition = matrixEntryIn.m_85861_();
        Matrix3f normal = matrixEntryIn.m_85864_();
        for (BCBox box : this.cubeList) {
            for (BCTexturedQuad texturedQuad : box.quads) {
                if (texturedQuad == null) continue;
                Vector3f vector3f = texturedQuad.normal.m_122281_();
                vector3f.m_122249_(normal);
                float f = vector3f.m_122239_();
                float f1 = vector3f.m_122260_();
                float f2 = vector3f.m_122269_();
                for (int i = 0; i < 4; ++i) {
                    BCVertex vertex = texturedQuad.getVertex(i);
                    float[] uv = texturedQuad.getUV(i);
                    float x = vertex.getX() / 16.0f;
                    float y = vertex.getY() / 16.0f;
                    float z = vertex.getZ() / 16.0f;
                    Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
                    vector4f.m_123607_(matrixPosition);
                    bufferIn.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), red, green, blue, alpha, uv[0], uv[1], packedOverlayIn, packedLightIn, f, f1, f2);
                }
            }
        }
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public Vec3 modelPositionWithParentsInverted(Vec3 holder) {
        Vec3 rendererPos = new Vec3(holder.m_7096_(), holder.m_7098_(), holder.m_7094_());
        Vec3 translation = new Vec3((double)(this.x / 16.0f), (double)(-this.y / 16.0f), (double)(-this.z / 16.0f));
        RotationMatrix matrixRotX = new RotationMatrix();
        RotationMatrix matrixRotY = new RotationMatrix();
        RotationMatrix matrixRotZ = new RotationMatrix();
        matrixRotX.rotX(this.xRot);
        matrixRotY.rotY(-this.yRot);
        matrixRotZ.rotZ(-this.zRot);
        rendererPos = matrixRotZ.getTransform(rendererPos);
        rendererPos = matrixRotX.getTransform(rendererPos);
        rendererPos = matrixRotY.getTransform(rendererPos);
        rendererPos = rendererPos.m_82549_(translation);
        if (this.parent != null) {
            return this.parent.modelPositionWithParentsInverted(rendererPos);
        }
        return new Vec3(rendererPos.m_7096_(), rendererPos.m_7098_(), rendererPos.m_7094_());
    }

    public void translateRotate(PoseStack matrixStackIn) {
        matrixStackIn.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
        }
    }

    public BCJoint addBox(String partName, float x, float y, float z, int width, int height, int depth, float delta, int texX, int texY) {
        this.uvOffset(texX, texY);
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror);
        return this;
    }

    public BCJoint addBox(float x, float y, float z, float width, float height, float depth) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, this.mirror);
        return this;
    }

    public BCJoint addBox(float x, float y, float z, float width, float height, float depth, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, mirrorIn);
        return this;
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, this.mirror);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, mirrorIn);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn) {
        this.cubeList.add((Object)new BCBox(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirorIn, this));
    }

    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn) {
        this.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void translateRotateWithParents(PoseStack matrixStackIn) {
        if (this.parent != null) {
            this.parent.translateRotateWithParents(matrixStackIn);
        }
        matrixStackIn.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
        }
    }

    public void translateRotateWithParentsInverted(PoseStack matrixStackIn) {
        if (this.parent != null) {
            this.parent.translateRotateWithParentsInverted(matrixStackIn);
        }
        matrixStackIn.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(-this.yRot));
        }
        if (this.xRot != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(-this.xRot));
        }
    }

    public Vec3 getAbsolutePosition(Vec3 holder, float partialTicks, LivingEntity entity) {
        Vec3 modelPosition = this.modelPositionWithParentsInverted(holder);
        double entityPositionX = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        double entityPositionY = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        double entityPositionZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        Vec3 entityPos = new Vec3(entityPositionX, entityPositionY, entityPositionZ);
        RotationMatrix matrixRotY = new RotationMatrix();
        matrixRotY.rotY((float)Math.toRadians(-entity.f_20883_));
        modelPosition = matrixRotY.getTransform(modelPosition);
        modelPosition = modelPosition.m_82520_(0.0, 1.5, 0.0);
        return entityPos.m_82549_(modelPosition);
    }

    @Override
    public void animationTransitionerPrevious(JointMutator previous, JointMutator current, float multiplier, float progression, Map<Easing, Float> easingMap) {
        float eased = (1.0f - easingMap.computeIfAbsent(current.getRotationEasing(), p -> Float.valueOf(p.progression(progression))).floatValue()) * multiplier;
        this.xRot += eased * previous.getRotationX();
        this.yRot += eased * previous.getRotationY();
        this.zRot += eased * previous.getRotationZ();
        eased = (1.0f - easingMap.computeIfAbsent(current.getOffsetEasing(), p -> Float.valueOf(p.progression(progression))).floatValue()) * multiplier;
        this.x += eased * previous.getOffsetX();
        this.y += eased * previous.getOffsetY();
        this.z += eased * previous.getOffsetZ();
        eased = (1.0f - easingMap.computeIfAbsent(current.getScaleEasing(), p -> Float.valueOf(p.progression(progression))).floatValue()) * multiplier;
        this.scaleX += eased * previous.getScaleX();
        this.scaleY += eased * previous.getScaleY();
        this.scaleZ += eased * previous.getScaleZ();
    }

    @Override
    public void animationTransitionerCurrent(JointMutator current, float multiplier, float progression, Map<Easing, Float> easingMap) {
        float eased = easingMap.computeIfAbsent(current.getRotationEasing(), p -> Float.valueOf(p.progression(progression))).floatValue() * multiplier;
        this.xRot += eased * current.getRotationX();
        this.yRot += eased * current.getRotationY();
        this.zRot += eased * current.getRotationZ();
        eased = easingMap.computeIfAbsent(current.getOffsetEasing(), p -> Float.valueOf(p.progression(progression))).floatValue() * multiplier;
        this.x += eased * current.getOffsetX();
        this.y += eased * current.getOffsetY();
        this.z += eased * current.getOffsetZ();
        eased = easingMap.computeIfAbsent(current.getScaleEasing(), p -> Float.valueOf(p.progression(progression))).floatValue() * multiplier;
        this.scaleX += eased * current.getScaleX();
        this.scaleY += eased * current.getScaleY();
        this.scaleZ += eased * current.getScaleZ();
    }

    public BCModel getModel() {
        return this.model;
    }

    @Nullable
    public BCJoint getMirrorJoint() {
        return this.mirrorJoint;
    }

    @Nullable
    public JointMirroring getMirrorType() {
        return this.mirrorType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public JointMutator newAnimationData() {
        return new JointMutator();
    }

    public static class Boxer {
        private final BCJoint joint;
        private float x;
        private float y;
        private float z;
        private float width;
        private float height;
        private float depth;
        private float deltaX;
        private float deltaY;
        private float deltaZ;
        private int u;
        private int v;
        private boolean mirror;

        Boxer(BCJoint joint) {
            this.joint = joint;
        }

        public Boxer pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Boxer dimension(float width, float height, float depth) {
            this.width = width;
            this.height = height;
            this.depth = depth;
            return this;
        }

        public Boxer delta(float x, float y, float z) {
            this.deltaX = x;
            this.deltaY = y;
            this.deltaZ = z;
            return this;
        }

        public Boxer delta(float amount) {
            this.x = amount;
            this.y = amount;
            this.z = amount;
            return this;
        }

        public Boxer uvPosition(int u, int v) {
            this.u = u;
            this.v = v;
            return this;
        }

        public Boxer mirror() {
            this.mirror = true;
            return this;
        }

        public BCBox implement() {
            BCBox box = new BCBox(this.u, this.v, this.x, this.y, this.z, this.width, this.height, this.depth, this.deltaX, this.deltaY, this.deltaZ, this.mirror, this.joint);
            this.joint.cubeList.add((Object)box);
            return box;
        }
    }
}

