/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry.managing;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.registry.managing.DeferrorType;
import bottomtextdanny.braincell.mod._base.registry.managing.ModDeferringManager;
import bottomtextdanny.braincell.mod._mod.common_sided.SolvingHook;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Wrap<T>
implements Supplier<T> {
    protected final ResourceLocation key;
    protected DeferrorType<? super T> type;
    @Nullable
    protected Supplier<T> sup;
    protected LinkedList<Consumer<T>> callOutStack;
    protected T obj;
    @Nullable
    private ModDeferringManager modSolvingState;

    public Wrap(ResourceLocation name, Supplier<T> sup) {
        Objects.requireNonNull(sup);
        this.sup = sup;
        this.key = name;
    }

    public void setupForDeferring(ModDeferringManager modSolvingState) {
        if (modSolvingState.isOpen()) {
            this.modSolvingState = modSolvingState;
        }
    }

    public void addSolvingCallout(Consumer<T> callOut) {
        if (this.callOutStack == null) {
            this.callOutStack = new LinkedList();
        }
        this.callOutStack.add(callOut);
    }

    public void solve() {
        SolvingHook<? super T> maybeHook;
        this.obj = this.sup.get();
        if (IForgeRegistryEntry.class.isAssignableFrom(this.obj.getClass())) {
            ((IForgeRegistryEntry)this.obj).setRegistryName(this.key);
        }
        if ((maybeHook = Braincell.common().getSolvingHooks().getHook(this.type)) instanceof Consumer) {
            Consumer hook = (Consumer)((Object)maybeHook);
            hook.accept(this.obj);
        }
        if (this.callOutStack != null) {
            this.callOutStack.forEach(call -> call.accept(this.obj));
            this.callOutStack = null;
        }
        this.sup = null;
    }

    @Override
    public T get() {
        return Objects.requireNonNull(this.obj, this.key.m_135827_() + " object called before being solved! key: " + this.key);
    }

    @Nullable
    public ModDeferringManager getModSolvingState() {
        return this.modSolvingState;
    }

    public ResourceLocation getKey() {
        return this.key;
    }
}

