/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry.managing;

import bottomtextdanny.braincell.mod._base.registry.managing.BCRegistry;
import bottomtextdanny.braincell.mod._base.registry.managing.ModDeferringManager;
import bottomtextdanny.braincell.mod._base.registry.managing.Wrap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper<T extends IForgeRegistryEntry<T>> {
    private final ModDeferringManager state;
    private final BCRegistry<T> registry;

    public RegistryHelper(ModDeferringManager state, BCRegistry<T> registry) {
        this.state = state;
        this.registry = registry;
    }

    public <U extends Wrap<? extends T>> U deferWrap(U sup) {
        Objects.requireNonNull(sup);
        sup.setupForDeferring(this.state);
        this.registry.addDeferredSolving(sup);
        return sup;
    }

    public <U extends T> Wrap<U> defer(String name, Supplier<U> sup) {
        Objects.requireNonNull(sup);
        Wrap<U> wrapped = new Wrap<U>(new ResourceLocation(this.state.getModID(), name), sup);
        wrapped.setupForDeferring(this.state);
        this.registry.addDeferredSolving(wrapped);
        return wrapped;
    }

    public <U extends T> U makeSideRegistry(String name, U object) {
        Objects.requireNonNull(object);
        object.setRegistryName(new ResourceLocation(this.state.getModID(), name));
        this.registry().addDeferredRegistry(() -> object);
        return object;
    }

    public ModDeferringManager state() {
        return this.state;
    }

    public BCRegistry<T> registry() {
        return this.registry;
    }
}

