/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry.managing;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.registry.managing.BCRegistry;
import bottomtextdanny.braincell.mod._base.registry.managing.DeferrorType;
import bottomtextdanny.braincell.mod._base.registry.managing.Wrap;
import bottomtextdanny.braincell.mod._mod.common_sided.SolvingHook;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModDeferringManager {
    public static final Supplier<UnsupportedOperationException> CANNOT_PERFORM_OPERATIONS_ON_CLOSED_STATE = () -> new UnsupportedOperationException("Attempted to perform operation on closed solving state");
    private final LinkedHashMap<DeferrorType<?>, BCRegistry<?>> deferrorAccessors;
    private final Map<DeferrorType<?>, SolvingHook<?>> hooks;
    private final String modID;
    boolean open = true;

    public ModDeferringManager(String modID) {
        this.modID = modID;
        this.deferrorAccessors = Maps.newLinkedHashMap();
        this.hooks = Maps.newIdentityHashMap();
    }

    public <T extends IForgeRegistryEntry<T>> void addRegistryDeferror(DeferrorType<T> type, BCRegistry<T> registry) {
        if (this.open) {
            if (this.deferrorAccessors.containsKey(type)) {
                throw ModDeferringManager.repeatedAccessorEntryException(type, this.modID);
            }
        } else {
            throw CANNOT_PERFORM_OPERATIONS_ON_CLOSED_STATE.get();
        }
        this.deferrorAccessors.put(type, registry);
    }

    public <T extends IForgeRegistryEntry<T>> Optional<BCRegistry<T>> getRegistryDeferror(DeferrorType<T> type) {
        return Optional.ofNullable(this.deferrorAccessors.get(type));
    }

    public void solveAndLockForeverEver() {
        if (this.open) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            GameData.unfreezeData();
            this.deferrorAccessors.forEach((type, registry) -> this.solveDeferror(bus, (DeferrorType)type, (BCRegistry<?>)registry));
            this.open = false;
        }
    }

    public <T extends IForgeRegistryEntry<T>> void addHook(DeferrorType<T> type, SolvingHook<T> hook) {
        if (this.open) {
            if (this.hooks.containsKey(type)) {
                this.hooks.put(type, this.hooks.get(type).append(hook));
            } else {
                this.hooks.put(type, hook);
            }
        } else {
            throw CANNOT_PERFORM_OPERATIONS_ON_CLOSED_STATE.get();
        }
    }

    @Nullable
    public <T extends IForgeRegistryEntry<T>> SolvingHook<T> getHook(DeferrorType<T> type) {
        if (this.hooks.containsKey(type)) {
            return this.hooks.get(type);
        }
        return null;
    }

    public <T extends IForgeRegistryEntry<T>> void doHooksForObject(DeferrorType<T> type, T object) {
        SolvingHook<T> defaultSolvingHook = Braincell.common().getSolvingHooks().getHook(type);
        SolvingHook<T> solvingHook = this.getHook(type);
        if (defaultSolvingHook != null) {
            defaultSolvingHook.execute(object, this);
        }
        if (solvingHook != null) {
            solvingHook.execute(object, this);
        }
    }

    private <T extends IForgeRegistryEntry<T>> void solveDeferror(IEventBus modEventBus, DeferrorType<T> type, BCRegistry<?> rawRegistry) {
        BCRegistry<?> registry = rawRegistry;
        SolvingHook<T> solvingHook = this.getHook(type);
        if (solvingHook != null) {
            SolvingHook<T> defaultSolvingHook = Braincell.common().getSolvingHooks().getHook(type);
            if (defaultSolvingHook != null) {
                solvingHook = solvingHook.append(defaultSolvingHook);
            }
            SolvingHook<T> finalSolvingHook = solvingHook;
            for (Supplier<?> entry : registry.getSolvingEntries()) {
                if (entry instanceof Wrap) {
                    Wrap wrap = (Wrap)entry;
                    wrap.solve();
                    if (wrap.obj == null) {
                        throw new IllegalStateException("Solving Object shouldn't point null after solving process. " + wrap.getKey().toString());
                    }
                }
                finalSolvingHook.execute((IForgeRegistryEntry)entry.get(), this);
            }
        } else {
            solvingHook = Braincell.common().getSolvingHooks().getHook(type);
            for (Supplier<?> entry : registry.getSolvingEntries()) {
                if (entry instanceof Wrap) {
                    Wrap wrap = (Wrap)entry;
                    wrap.solve();
                    if (wrap.obj == null) {
                        throw new IllegalStateException("Solving Object shouldn't be null after solving process.");
                    }
                }
                if (solvingHook == null) continue;
                solvingHook.execute((IForgeRegistryEntry)entry.get(), this);
            }
        }
        modEventBus.addGenericListener(type.getClassRef(), registry::registerAll);
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getModID() {
        return this.modID;
    }

    private static IllegalArgumentException repeatedAccessorEntryException(DeferrorType<?> accessorKey, String modId) {
        String message = "Cannot assign value to accessor key because there is already one; Accessor key:" + accessorKey.getKey() + ", Mod id:" + modId + '.';
        return new IllegalArgumentException(message);
    }
}

