/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry.item_extensions;

import bottomtextdanny.braincell.mod._base.registry.item_extensions.ExtraItemModelLoader;
import bottomtextdanny.braincell.mod._base.registry.item_extensions.ExtraModelData;
import bottomtextdanny.braincell.mod.network.Connection;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.extensions.IForgeItem;

public interface ExtraModelProvider
extends IForgeItem,
ExtraItemModelLoader {
    public static final Map<Item, Int2ObjectArrayMap<ModelResourceLocation>> MODEL_FETCH = new HashMap<Item, Int2ObjectArrayMap<ModelResourceLocation>>();

    default public void fetchFrom(ExtraModelData ... models) {
        Connection.doClientSide(() -> {
            Int2ObjectArrayMap int2ModelMap = new Int2ObjectArrayMap(models.length);
            for (ExtraModelData model : models) {
                int2ModelMap.put(model.index(), (Object)model.location());
            }
            MODEL_FETCH.put((Item)this, (Int2ObjectArrayMap<ModelResourceLocation>)int2ModelMap);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public ResourceLocation fetchModelDir(int key) {
        if (MODEL_FETCH.get((Item)this).containsKey(key)) {
            return (ResourceLocation)MODEL_FETCH.get((Item)this).get(key);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public BakedModel fetchModel(ItemRenderer itemRenderer, int key) {
        if (MODEL_FETCH.get((Item)this).containsKey(key)) {
            return itemRenderer.m_115103_().m_109393_().m_119422_((ModelResourceLocation)MODEL_FETCH.get((Item)this).get(key));
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void bake(ModelRegistryEvent event) {
        if (this.getRegistryName() != null) {
            Int2ObjectArrayMap<ModelResourceLocation> keyMap = MODEL_FETCH.get(this);
            int size = keyMap.size();
            for (int i = 0; i < size; ++i) {
                ForgeModelBakery.addSpecialModel((ResourceLocation)((ResourceLocation)keyMap.get(i)));
            }
        }
    }
}

