/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry.block_extensions;

import bottomtextdanny.braincell.mod._base.registry.block_extensions.ExtraBlockRegisterer;
import bottomtextdanny.braincell.mod._base.registry.managing.BCRegistry;
import bottomtextdanny.braincell.mod._base.registry.managing.DeferrorType;
import bottomtextdanny.braincell.mod._base.registry.managing.ModDeferringManager;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public interface ExtraPottedPlantRegisterer<T extends Block, U extends FlowerPotBlock>
extends ExtraBlockRegisterer<T> {
    @Override
    default public void registerExtra(T object, ModDeferringManager solving) {
        Objects.requireNonNull(object);
        Optional<BCRegistry<Block>> registryOp = solving.getRegistryDeferror(DeferrorType.BLOCK);
        registryOp.ifPresent(registry -> {
            FlowerPotBlock newPotBlock = (FlowerPotBlock)this.pottedFactory(object).get();
            newPotBlock.setRegistryName(new ResourceLocation(solving.getModID(), "potted_" + object.getRegistryName().m_135815_()));
            solving.doHooksForObject(DeferrorType.BLOCK, newPotBlock);
            registry.addDeferredRegistry(() -> newPotBlock);
            this.decPotted(newPotBlock);
        });
    }

    public void decPotted(U var1);

    default public Supplier<U> pottedFactory(T base) {
        return () -> new FlowerPotBlock(base, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_());
    }

    @Override
    default public boolean executeSideRegistry() {
        return true;
    }

    public U potted();
}

