/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.registry.EggBuildData;
import bottomtextdanny.braincell.mod._base.registry.managing.DeferrorType;
import bottomtextdanny.braincell.mod._base.registry.managing.Wrap;
import bottomtextdanny.braincell.mod.world.builtin_items.BCSpawnEggItem;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class EntityWrap<T extends EntityType<?>>
extends Wrap<T> {
    public EntityWrap(ResourceLocation name, Supplier<T> sup) {
        super(name, sup);
    }

    @Override
    public void solve() {
        super.solve();
        EggBuildData eggBuilderData = Braincell.common().getEntityCoreDataDeferror().getEggBuilder(this.key);
        if (eggBuilderData == null) {
            return;
        }
        ResourceLocation eggKey = new ResourceLocation(this.getModSolvingState().getModID(), eggBuilderData.name() + "_spawn_egg");
        BCSpawnEggItem.Builder eggBuilder = eggBuilderData.builder();
        Objects.requireNonNull(eggBuilderData.builder(), String.join((CharSequence)"Attempted to register a null egg for entity type ", this.key.toString()));
        BCSpawnEggItem egg = eggBuilder.setTypeSupplier(() -> (EntityType)this.obj).build();
        this.getModSolvingState().getRegistryDeferror(DeferrorType.ITEM).get().addDeferredRegistry(() -> egg);
        this.getModSolvingState().doHooksForObject(DeferrorType.ITEM, egg);
        if (eggBuilder.getSort() != -1) {
            Braincell.common().getItemSortData().setSortValue(eggKey, eggBuilder.getSort());
        }
        egg.setRegistryName(eggKey);
    }
}

