/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry;

import bottomtextdanny.braincell.base.BCSuppliers;
import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.mixin.StructureFeatureMixin;
import bottomtextdanny.braincell.mod._base.registry.BCStructureData;
import bottomtextdanny.braincell.mod._base.registry.managing.Wrap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class BCStructureRegistry<T extends StructureFeature<?>>
extends Wrap<T> {
    private final List<StructurePieceType> pieces;
    private Runnable auxiliar;
    private ResourceKey<StructureSet> structureSetRegistry;
    private Holder<StructureSet> structureSet;
    private BCStructureData<T> data;
    private boolean built = false;

    public BCStructureRegistry(ResourceLocation name, Supplier<T> sup, GenerationStep.Decoration step, List<StructurePieceType> pieces, List<Pair<ResourceLocation, Function<BCStructureRegistry<T>, ConfiguredStructureFeature<?, ?>>>> configured, ResourceLocation setKey, Function<BCStructureRegistry<T>, StructureSet> setMod, Runnable auxiliar) {
        super(name, sup);
        this.pieces = pieces;
        this.auxiliar = auxiliar;
        this.data = new BCStructureData.Pre<T>(configured.stream().map(p -> Pair.of((ResourceLocation)p.left(), BCSuppliers.compose((Function)p.right(), this))).toList(), setKey, setMod);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> StructureFeatureMixin.getSTEP().put((StructureFeature)this.obj, step));
    }

    public static <T extends StructureFeature<?>> Builder<T> builder(ResourceLocation key, Supplier<T> sup, GenerationStep.Decoration step) {
        return new Builder<T>(key, sup, step);
    }

    public StructurePieceType getPiece(int index) {
        if (this.built) {
            return this.pieces.get(index);
        }
        throw BCStructureRegistry.unbuiltException();
    }

    public Holder<ConfiguredStructureFeature<?, ?>> getConfigured(int index) {
        if (this.built) {
            return ((BCStructureData.Post)this.data).confGetter().get(index);
        }
        throw BCStructureRegistry.unbuiltException();
    }

    @Override
    public void solve() {
        super.solve();
        this.makeExtraRegistries();
        if (this.auxiliar != null) {
            this.auxiliar.run();
            this.auxiliar = null;
        }
    }

    public void makeExtraRegistries() {
        BCStructureData<T> bCStructureData = this.data;
        if (bCStructureData instanceof BCStructureData.Pre) {
            BCStructureData.Pre pre = (BCStructureData.Pre)bCStructureData;
            this.built = true;
            this.data = pre.makePost((rl, type) -> BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)rl, (Object)((ConfiguredStructureFeature)type.get())));
            this.structureSetRegistry = ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)pre.setKey());
            this.structureSet = BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_211084_, this.structureSetRegistry, (Object)pre.setMod().apply(this));
        }
    }

    private static IllegalStateException unbuiltException() {
        return new IllegalStateException("Extra structure registries are yet to be built.");
    }

    public static class Builder<T extends StructureFeature<?>> {
        private final ResourceLocation key;
        private final Supplier<T> supplier;
        private final GenerationStep.Decoration step;
        private final List<StructurePieceType> pieces;
        private final List<Pair<ResourceLocation, Function<BCStructureRegistry<T>, ConfiguredStructureFeature<?, ?>>>> confGetter;
        private ResourceLocation structureSetKey;
        private Function<BCStructureRegistry<T>, StructureSet> structureSetGetter;
        private Runnable auxiliar;

        Builder(ResourceLocation key, Supplier<T> supplier, GenerationStep.Decoration step) {
            this.key = key;
            this.supplier = supplier;
            this.step = step;
            this.pieces = Lists.newLinkedList();
            this.confGetter = Lists.newLinkedList();
        }

        public Builder<T> piece(String key, StructurePieceType type) {
            if (this.auxiliar == null) {
                this.auxiliar = () -> Registry.m_122961_((Registry)Registry.f_122843_, (String)key.toLowerCase(Locale.ROOT), (Object)type);
            } else {
                Runnable runnable = this.auxiliar;
                this.auxiliar = () -> {
                    runnable.run();
                    Registry.m_122961_((Registry)Registry.f_122843_, (String)key.toLowerCase(Locale.ROOT), (Object)type);
                };
            }
            this.pieces.add(type);
            return this;
        }

        public Builder<T> configured(ResourceLocation key, Function<BCStructureRegistry<T>, ConfiguredStructureFeature<?, ?>> type) {
            this.confGetter.add(Pair.of(key, type));
            return this;
        }

        public Builder<T> set(ResourceLocation structureSetKey, Function<BCStructureRegistry<T>, StructureSet> structureSetFunction) {
            this.structureSetKey = structureSetKey;
            this.structureSetGetter = structureSetFunction;
            return this;
        }

        public BCStructureRegistry<T> build() {
            return new BCStructureRegistry<T>(this.key, this.supplier, this.step, this.pieces, this.confGetter, this.structureSetKey, this.structureSetGetter, this.auxiliar);
        }
    }
}

