/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.registry;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.registry.EntityBuilder;
import bottomtextdanny.braincell.mod._base.registry.EntityWrap;
import bottomtextdanny.braincell.mod._base.registry.managing.BCRegistry;
import bottomtextdanny.braincell.mod._base.registry.managing.ModDeferringManager;
import bottomtextdanny.braincell.mod._mod.client_sided.EntityRendererDeferring;
import bottomtextdanny.braincell.mod._mod.client_sided.EntityRendererMaker;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.braincell.mod.world.builtin_items.BCSpawnEggItem;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;

public class BCEntityBuilder<T extends Entity>
implements EntityBuilder<T> {
    private final ModDeferringManager solving;
    private final BCRegistry<EntityType<?>> registry;
    protected String entityId;
    protected EntityType.EntityFactory<T> factory;
    protected MobCategory classification;
    protected float width;
    protected float height;
    protected Supplier<?> renderFactory;

    public BCEntityBuilder(BCRegistry<EntityType<?>> registry, ModDeferringManager solving) {
        this.solving = solving;
        this.registry = registry;
    }

    @Override
    public BCEntityBuilder<T> declare(String entityId, EntityType.EntityFactory<T> factory) {
        this.entityId = entityId;
        this.factory = factory;
        return this;
    }

    @Override
    public BCEntityBuilder<T> classification(MobCategory classification) {
        this.classification = classification;
        return this;
    }

    @Override
    public BCEntityBuilder<T> dimensions(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public BCEntityBuilder<T> renderer(Supplier<? extends Function<?, ?>> renderer) {
        Connection.doClientSide(() -> {
            this.renderFactory = () -> BCEntityBuilder.lambda$renderer$0((Supplier)renderer);
        });
        return this;
    }

    @Override
    @Deprecated
    public BCEntityBuilder<T> attributes(Supplier<AttributeSupplier.Builder> attributeMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public BCEntityBuilder<T> spawn(SpawnPlacements.Type placement, Heightmap.Types heightMap, SpawnPlacements.SpawnPredicate<T> pred) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public BCEntityBuilder<T> egg(BCSpawnEggItem.Builder egg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityWrap<EntityType<T>> build() {
        EntityWrap<EntityType<T>> type = new EntityWrap<EntityType<T>>(new ResourceLocation(this.solving.getModID(), this.entityId), () -> EntityType.Builder.m_20704_(this.factory, (MobCategory)this.classification).m_20699_(this.width, this.height).m_20712_(this.solving.getModID() + ":" + this.entityId));
        type.setupForDeferring(this.solving);
        this.registry.addDeferredSolving(type);
        Connection.doClientSide(() -> {
            if (this.renderFactory != null) {
                Braincell.client().getEntityRendererDeferror().add(new EntityRendererDeferring(type, this.renderFactory));
            }
        });
        return type;
    }

    private static /* synthetic */ Object lambda$renderer$0(Supplier renderer) {
        return EntityRendererMaker.makeOf((Function)renderer.get());
    }
}

