/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter.schema;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.BCStringUtil;
import bottomtextdanny.braincell.mod.PropertyMap;
import bottomtextdanny.braincell.mod._base.plotter.schema.FlagsEntry;
import bottomtextdanny.braincell.mod._base.plotter.schema.Schema;
import bottomtextdanny.braincell.mod._base.plotter.schema.SchemaMemo;
import bottomtextdanny.braincell.mod._base.plotter.schema.SchemaPropertyValueGetter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import org.apache.commons.io.IOUtils;

public final class SchemaManager {
    public static final String M_BASE = "ba";
    public static final String M_ENTRIES = "en";
    public static final String M_ENTRY_NAME = "na";
    public static final String M_ENTRY_FLAGS = "fl";
    public static final String M_BLOCK_DATA = "bp";
    public static final String M_PROPERTY_ENTRIES = "prop";
    public static final String M_PROPERTY_ENTRIES_NAME = "id";
    public static final String M_PROPERTY_ENTRIES_VALUES = "val";
    private final Map<ResourceLocation, SchemaMemo> cache = new HashMap<ResourceLocation, SchemaMemo>(1024);
    private final Key key = new Key();
    private MinecraftServer server;

    public SchemaManager() {
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
    }

    private void onServerStart(ServerStartingEvent event) {
        this.server = event.getServer();
        this.cache.forEach((rl, memo) -> this.parseSchema((ResourceLocation)rl));
    }

    public SchemaMemo parseSchema(ResourceLocation dir) {
        if (!this.active()) {
            SchemaMemo memo = SchemaManager.unbuiltMemo(dir);
            this.cache.put(dir, memo);
            return memo;
        }
        boolean existing = this.cache.containsKey(dir);
        if (existing && this.cache.get(dir).isBuilt()) {
            return this.cache.get(dir);
        }
        SchemaMemo memo = existing ? this.cache.get(dir) : SchemaManager.unbuiltMemo(dir);
        Schema schema = null;
        String file = null;
        JsonObject json = null;
        try {
            StringWriter strBuf = new StringWriter();
            IOUtils.copy((InputStream)this.server.m_177941_().m_142591_(dir).m_6679_(), (Writer)strBuf, (String)"UTF-8");
            file = strBuf.toString();
        }
        catch (Exception ex) {
            SchemaManager.failedParsing(dir, "the file does not exist or cannot be read as text.");
            ex.printStackTrace();
        }
        if (file != null) {
            try {
                json = GsonHelper.m_13864_(file);
            }
            catch (Exception ignored) {
                SchemaManager.failedParsing(dir, "the file cannot be parsed as json.");
            }
        }
        if (json != null) {
            try {
                JsonObject entrySerial;
                JsonArray flagEntriesSerial = json.get(M_ENTRIES).getAsJsonArray();
                JsonArray propertyEntriesSerial = json.get(M_PROPERTY_ENTRIES).getAsJsonArray();
                JsonArray blockDataArraySerial = json.get(M_BLOCK_DATA).getAsJsonArray();
                ArrayList propertyValueMatrix = Lists.newArrayList();
                ArrayList flagsEntries = Lists.newArrayList();
                ArrayList schemaBlockPositions = Lists.newArrayList();
                IntArrayList schemaIndices = new IntArrayList();
                ArrayList schemaPropertyValueIndices = Lists.newArrayList();
                Iterator propertyEntriesSerialIterator = propertyEntriesSerial.iterator();
                Iterator entriesSerialIterator = flagEntriesSerial.iterator();
                Iterator blockDataArraySerialIterator = blockDataArraySerial.iterator();
                while (propertyEntriesSerialIterator.hasNext()) {
                    entrySerial = ((JsonElement)propertyEntriesSerialIterator.next()).getAsJsonObject();
                    String name = entrySerial.get(M_PROPERTY_ENTRIES_NAME).getAsString();
                    Object property = PropertyMap.getProperty(name);
                    ArrayList values = Lists.newArrayList();
                    propertyValueMatrix.add(new SchemaPropertyValueGetter(property, Collections.unmodifiableList(values)));
                    for (JsonElement element : entrySerial.get(M_PROPERTY_ENTRIES_VALUES).getAsJsonArray()) {
                        String valueString = element.getAsString();
                        values.add(property.m_6215_(valueString).get());
                    }
                }
                while (entriesSerialIterator.hasNext()) {
                    entrySerial = ((JsonElement)entriesSerialIterator.next()).getAsJsonObject();
                    JsonArray flagsSerial = entrySerial.get(M_ENTRY_FLAGS).getAsJsonArray();
                    Iterator flagsIterator = flagsSerial.iterator();
                    IntArrayList flagList = new IntArrayList();
                    IntOpenHashSet flagSet = new IntOpenHashSet();
                    while (flagsIterator.hasNext()) {
                        int flag = Math.abs(((JsonElement)flagsIterator.next()).getAsInt());
                        flagList.add(flag);
                        flagSet.add(flag);
                    }
                    flagsEntries.add(new FlagsEntry(entrySerial.get(M_ENTRY_NAME).getAsString(), (IntList)flagList, (IntSet)flagSet));
                }
                while (blockDataArraySerialIterator.hasNext()) {
                    JsonArray blockDataSerial = ((JsonElement)blockDataArraySerialIterator.next()).getAsJsonArray();
                    Iterator blockDataIterator = blockDataSerial.iterator();
                    IntArrayList propertyValueList = new IntArrayList();
                    int counter = 0;
                    while (blockDataIterator.hasNext()) {
                        int intValue = ((JsonElement)blockDataIterator.next()).getAsInt();
                        if (counter > 3) {
                            propertyValueList.add(intValue);
                        }
                        ++counter;
                    }
                    schemaPropertyValueIndices.add(propertyValueList);
                    schemaBlockPositions.add(new BlockPos(blockDataSerial.get(0).getAsInt(), blockDataSerial.get(1).getAsInt(), blockDataSerial.get(2).getAsInt()));
                    schemaIndices.add(blockDataSerial.get(3).getAsInt());
                }
                schema = new Schema(Collections.unmodifiableList(propertyValueMatrix), flagsEntries, schemaBlockPositions, schemaPropertyValueIndices, (IntList)schemaIndices);
                this.cache.put(dir, memo);
                memo.setBuilt(schema, this.key);
            }
            catch (Exception ex) {
                SchemaManager.failedParsing(dir, "the json file has invalid schema metadata.");
                ex.printStackTrace();
            }
        }
        return memo;
    }

    public static SchemaMemo parseStatically(ResourceLocation location) {
        return Braincell.common().getSchemaManager().parseSchema(location);
    }

    private boolean active() {
        return this.server != null;
    }

    private static SchemaMemo unbuiltMemo(ResourceLocation location) {
        return new SchemaMemo(location);
    }

    private static void failedParsing(ResourceLocation filename, String message) {
        new UnexpectedException(BCStringUtil.params("Couldn't deserialize schema file at {} because {}", filename, message)).printStackTrace();
    }

    public static class Key {
        private Key() {
        }
    }
}

