/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter.iterator;

import bottomtextdanny.braincell.mod._base.plotter.PlotterRotator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public class RotatedBlockPos
extends BlockPos {
    public final Rotation rotation;

    public RotatedBlockPos(Rotation rotation, int x, int y, int z) {
        super(x, y, z);
        this.rotation = rotation;
    }

    public RotatedBlockPos(Rotation rotation, double x, double y, double z) {
        super(x, y, z);
        this.rotation = rotation;
    }

    public RotatedBlockPos(Rotation rotation, Vec3 vec) {
        this(rotation, vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public RotatedBlockPos(Rotation rotation, Position vec) {
        this(rotation, vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
    }

    public RotatedBlockPos(Rotation rotation, Vec3i vec) {
        this(rotation, vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    protected RotatedBlockPos getRotationOf(Vec3i vec) {
        return new RotatedBlockPos(this.rotation, (Vec3i)PlotterRotator.rotatedOf(this.rotation, vec));
    }

    protected RotatedBlockPos getRotationOf(int x, int y, int z) {
        return new RotatedBlockPos(this.rotation, (Vec3i)PlotterRotator.rotatedOf(this.rotation, x, y, z));
    }

    public RotatedBlockPos offset(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? this : new RotatedBlockPos(this.rotation, (Vec3i)this.getRotationOf(this.m_123341_() + (int)x, this.m_123342_() + (int)y, this.m_123343_() + (int)z));
    }

    public RotatedBlockPos offset(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new RotatedBlockPos(this.rotation, (Vec3i)this.getRotationOf(this.m_123341_() + x, this.m_123342_() + y, this.m_123343_() + z));
    }

    public RotatedBlockPos offset(Vec3i vec) {
        return this.offset(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public RotatedBlockPos subtract(Vec3i vec) {
        return this.offset(-vec.m_123341_(), -vec.m_123342_(), -vec.m_123343_());
    }

    public RotatedBlockPos multiply(int scaler) {
        if (scaler == 1) {
            return this;
        }
        return new RotatedBlockPos(this.rotation, this.m_123341_() * scaler, this.m_123342_() * scaler, this.m_123343_() * scaler);
    }

    public RotatedBlockPos above() {
        return this.relative(Direction.UP);
    }

    public RotatedBlockPos above(int p_121972_) {
        return this.relative(Direction.UP, p_121972_);
    }

    public RotatedBlockPos below() {
        return this.relative(Direction.DOWN);
    }

    public RotatedBlockPos below(int p_122000_) {
        return this.relative(Direction.DOWN, p_122000_);
    }

    public RotatedBlockPos north() {
        return this.relative(Direction.NORTH);
    }

    public RotatedBlockPos north(int p_122014_) {
        return this.relative(Direction.NORTH, p_122014_);
    }

    public RotatedBlockPos south() {
        return this.relative(Direction.SOUTH);
    }

    public RotatedBlockPos south(int p_122021_) {
        return this.relative(Direction.SOUTH, p_122021_);
    }

    public RotatedBlockPos west() {
        return this.relative(Direction.WEST);
    }

    public RotatedBlockPos west(int p_122026_) {
        return this.relative(Direction.WEST, p_122026_);
    }

    public RotatedBlockPos east() {
        return this.relative(Direction.EAST);
    }

    public RotatedBlockPos east(int p_122031_) {
        return this.relative(Direction.EAST, p_122031_);
    }

    public RotatedBlockPos relative(Direction direction) {
        direction = this.rotation.m_55954_(direction);
        return new RotatedBlockPos(this.rotation, this.m_123341_() + direction.m_122429_(), this.m_123342_() + direction.m_122430_(), this.m_123343_() + direction.m_122431_());
    }

    public RotatedBlockPos relative(Direction direction, int steps) {
        direction = this.rotation.m_55954_(direction);
        return steps == 0 ? this : new RotatedBlockPos(this.rotation, this.m_123341_() + direction.m_122429_() * steps, this.m_123342_() + direction.m_122430_() * steps, this.m_123343_() + direction.m_122431_() * steps);
    }

    public RotatedBlockPos relative(Direction.Axis axis, int steps) {
        axis = PlotterRotator.AXIS_ROTATOR.get(axis.ordinal()).apply(this.rotation);
        if (steps == 0) {
            return this;
        }
        int i = axis == Direction.Axis.X ? steps : 0;
        int j = axis == Direction.Axis.Y ? steps : 0;
        int k = axis == Direction.Axis.Z ? steps : 0;
        return new RotatedBlockPos(this.rotation, this.m_123341_() + i, this.m_123342_() + j, this.m_123343_() + k);
    }

    public RotatedBlockPos rotate(Rotation rotation) {
        return new RotatedBlockPos(this.rotation, (Vec3i)PlotterRotator.rotatedOf(this.rotation.m_55952_(rotation), (Vec3i)this));
    }

    public RotatedBlockPos cross(Vec3i other) {
        other = this.getRotationOf((Vec3i)other);
        return new RotatedBlockPos(this.rotation, this.m_123342_() * other.m_123343_() - this.m_123343_() * other.m_123342_(), this.m_123343_() * other.m_123341_() - this.m_123341_() * other.m_123343_(), this.m_123341_() * other.m_123342_() - this.m_123342_() * other.m_123341_());
    }

    public RotatedBlockPos atY(int yLevel) {
        return new RotatedBlockPos(this.rotation, this.m_123341_(), yLevel, this.m_123343_());
    }

    public RotatedBlockPos immutable() {
        return this;
    }

    @Deprecated
    public BlockPos.MutableBlockPos m_122032_() {
        return new BlockPos.MutableBlockPos(this.m_123341_(), this.m_123342_(), this.m_123343_());
    }

    public Mutable mutableRotable() {
        return new Mutable(this.rotation, this.m_123341_(), this.m_123342_(), this.m_123343_());
    }

    public static class Mutable
    extends RotatedBlockPos {
        public Mutable(Rotation rotation) {
            this(rotation, 0, 0, 0);
        }

        public Mutable(Rotation rotation, int x, int y, int z) {
            super(rotation, x, y, z);
        }

        public Mutable(Rotation rotation, double x, double y, double z) {
            this(rotation, Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        }

        @Override
        public RotatedBlockPos offset(double x, double y, double z) {
            return super.offset(x, y, z).immutable();
        }

        @Override
        public RotatedBlockPos offset(int x, int y, int z) {
            return super.offset(x, y, z).immutable();
        }

        @Override
        public RotatedBlockPos multiply(int scaler) {
            return super.multiply(scaler).immutable();
        }

        @Override
        public RotatedBlockPos relative(Direction direction, int steps) {
            return super.relative(direction, steps).immutable();
        }

        @Override
        public RotatedBlockPos relative(Direction.Axis axisDirection, int steps) {
            return super.relative(axisDirection, steps).immutable();
        }

        @Override
        public RotatedBlockPos rotate(Rotation rotation) {
            return super.rotate(rotation).immutable();
        }

        public Mutable set(int x, int y, int z) {
            this.setX(x);
            this.setY(y);
            this.setZ(z);
            return this;
        }

        public Mutable set(double x, double y, double z) {
            return this.set(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        }

        public Mutable set(Vec3i vec) {
            return this.set(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }

        public Mutable setWithOffset(Vec3i vec, Direction direction) {
            direction = this.rotation.m_55954_(direction);
            return this.set(vec.m_123341_() + direction.m_122429_(), vec.m_123342_() + direction.m_122430_(), vec.m_123343_() + direction.m_122431_());
        }

        public Mutable setWithOffset(Vec3i vec, int x, int y, int z) {
            RotatedBlockPos rotatedOffset = this.getRotationOf(x, y, z);
            return this.set(vec.m_123341_() + rotatedOffset.m_123341_(), vec.m_123342_() + rotatedOffset.m_123342_(), vec.m_123343_() + rotatedOffset.m_123343_());
        }

        public Mutable setWithOffset(Vec3i vec, Vec3i offset) {
            offset = this.getRotationOf((Vec3i)offset);
            return this.set(vec.m_123341_() + offset.m_123341_(), vec.m_123342_() + offset.m_123342_(), vec.m_123343_() + offset.m_123343_());
        }

        public Mutable move(Direction direction) {
            direction = this.rotation.m_55954_(direction);
            return this.move(direction, 1);
        }

        public Mutable move(Direction direction, int steps) {
            direction = this.rotation.m_55954_(direction);
            return this.set(this.m_123341_() + direction.m_122429_() * steps, this.m_123342_() + direction.m_122430_() * steps, this.m_123343_() + direction.m_122431_() * steps);
        }

        public Mutable move(int x, int y, int z) {
            RotatedBlockPos rotatedOffset = this.getRotationOf(x, y, z);
            return this.set(this.m_123341_() + rotatedOffset.m_123341_(), this.m_123342_() + rotatedOffset.m_123342_(), this.m_123343_() + rotatedOffset.m_123343_());
        }

        public Mutable move(Vec3i vec) {
            vec = this.getRotationOf((Vec3i)vec);
            return this.set(this.m_123341_() + vec.m_123341_(), this.m_123342_() + vec.m_123342_(), this.m_123343_() + vec.m_123343_());
        }

        public Mutable clamp(Direction.Axis p_122148_, int p_122149_, int p_122150_) {
            switch (p_122148_) {
                case X: {
                    return this.set(Mth.m_14045_((int)this.m_123341_(), (int)p_122149_, (int)p_122150_), this.m_123342_(), this.m_123343_());
                }
                case Y: {
                    return this.set(this.m_123341_(), Mth.m_14045_((int)this.m_123342_(), (int)p_122149_, (int)p_122150_), this.m_123343_());
                }
                case Z: {
                    return this.set(this.m_123341_(), this.m_123342_(), Mth.m_14045_((int)this.m_123343_(), (int)p_122149_, (int)p_122150_));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + p_122148_);
        }

        public Mutable setX(int p_175341_) {
            super.m_142451_(p_175341_);
            return this;
        }

        public Mutable setY(int p_175343_) {
            super.m_142448_(p_175343_);
            return this;
        }

        public Mutable setZ(int p_175345_) {
            super.m_142443_(p_175345_);
            return this;
        }

        @Override
        public RotatedBlockPos immutable() {
            return new RotatedBlockPos(this.rotation, (Vec3i)this);
        }
    }
}

