/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter;

import bottomtextdanny.braincell.mod._base.plotter.Plotter;
import bottomtextdanny.braincell.mod._base.plotter.PlotterRotator;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;

public abstract class SpecialPlotter<DATA extends PlotterData>
implements Plotter<DATA> {
    protected static final RandomGenerator NT_RANDOM = new SplittableRandom();
    protected final LevelAccessor level;
    private List<Plotter.ChildTicket> children;
    private final Map<Integer, PlotterIterator<DATA>> iteratorMap;
    private PlotterIterator<DATA> firstIterator;

    public SpecialPlotter(LevelAccessor level) {
        this.level = level;
        this.children = Lists.newArrayList();
        this.iteratorMap = Maps.newHashMap();
    }

    @Override
    public LevelAccessor level() {
        return this.level;
    }

    @Override
    public void modify(int priority, PlotterIterator<DATA> plot) {
        if (priority == 0) {
            this.firstIterator = this.firstIterator == null ? plot : this.firstIterator.andThen(plot);
        }
        if (this.iteratorMap.containsKey(priority)) {
            this.iteratorMap.put(priority, this.iteratorMap.get(priority).andThen(plot));
        } else {
            this.iteratorMap.put(priority, plot);
        }
    }

    @Override
    public void addChild(Vec3i offset, Plotter<?> other) {
        this.children.add(new Plotter.ChildTicket((Vec3i)new BlockPos(offset), other));
    }

    @Override
    public void makeFirst(Int2ObjectArrayMap<List<Plotter.PlotterIteration<?>>> extraIterCollector, BlockPos pos, Rotation rotation) {
        ArrayList<Plotter.ChildTicket> childrenRestoreCopy = new ArrayList<Plotter.ChildTicket>(this.children);
        this.iteratorMap.forEach((prior, iter) -> {
            if (prior != null) {
                Plotter.PlotterIteration deferred = new Plotter.PlotterIteration(this, iter, pos, rotation);
                if (!extraIterCollector.containsKey(prior)) {
                    LinkedList list = Lists.newLinkedList();
                    list.add(deferred);
                    extraIterCollector.put(prior, (Object)list);
                } else {
                    ((List)extraIterCollector.get(prior)).add(deferred);
                }
            }
        });
        if (this.firstIterator != null) {
            this.make(this.firstIterator, pos, rotation);
        }
        this.children.forEach(c -> c.child().makeFirst(extraIterCollector, pos.m_141952_((Vec3i)PlotterRotator.rotatedOf(rotation, c.offset())), rotation));
        this.children = childrenRestoreCopy;
    }

    @Override
    public void make(PlotterIterator<DATA> iterator, BlockPos pos, Rotation rotation) {
        this.makeOwnThing(pos, iterator, rotation);
    }

    public abstract void makeOwnThing(BlockPos var1, PlotterIterator<DATA> var2, Rotation var3);
}

