/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter;

import bottomtextdanny.braincell.mod._base.plotter.Plotter;
import bottomtextdanny.braincell.mod._base.plotter.PlotterRotator;
import bottomtextdanny.braincell.mod._base.plotter.SpecialPlotter;
import bottomtextdanny.braincell.mod._base.plotter.iterator.MutablePlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterIterator;
import bottomtextdanny.braincell.mod._base.plotter.schema.FlagsEntry;
import bottomtextdanny.braincell.mod._base.plotter.schema.Schema;
import bottomtextdanny.braincell.mod._base.plotter.schema.SchemaGetter;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.util.TriConsumer;

public class SchemaPlotter
extends SpecialPlotter<Data> {
    private final SchemaGetter list;

    public SchemaPlotter(LevelAccessor level, SchemaGetter list) {
        super(level);
        this.list = list;
    }

    @Override
    public void makeOwnThing(BlockPos pos, PlotterIterator<Data> iterator, Rotation rotation) {
        MuData data = new MuData(this, null, null, null, null, NT_RANDOM);
        Schema schema = this.list.make(this.level, NT_RANDOM);
        schema.iterate((TriConsumer<BlockPos, IntList, FlagsEntry>)((TriConsumer)(lp, p, f) -> {
            lp = PlotterRotator.rotatedOf(rotation, (Vec3i)lp);
            BlockPos worldPos = pos.m_141952_((Vec3i)lp);
            BlockState state = this.level.m_8055_(worldPos);
            data.setEntry((FlagsEntry)f);
            data.setPropertiesInjector(blockState -> {
                int propertiesSize = p.size();
                for (int i = 0; i < propertiesSize; i += 2) {
                    blockState = schema.tryInferPropertyValue(p.getInt(i), p.getInt(i + 1), (BlockState)blockState);
                }
                return blockState;
            });
            data.setState(state);
            data.setOriginalState(state);
            data.setLocalPos((BlockPos)lp);
            data.setBlockPos(worldPos);
            iterator.accept(data);
            this.level.m_7731_(worldPos, PlotterRotator.rotateBlockState(rotation, data.state()), 3);
        }));
    }

    private static class MuData
    extends MutablePlotterData
    implements Data {
        private static final Function<BlockState, BlockState> IDENTITY = Function.identity();
        private Function<BlockState, BlockState> inferProperties = IDENTITY;
        private FlagsEntry entry;

        public MuData(Plotter<?> plotter, BlockState state, BlockState originalState, BlockPos blockPos, BlockPos localPos, RandomGenerator random) {
            super(plotter, state, originalState, blockPos, localPos, random);
        }

        @Override
        public BlockState infer(BlockState blockState) {
            return this.inferProperties.apply(blockState);
        }

        public void setPropertiesInjector(Function<BlockState, BlockState> inferProperties) {
            this.inferProperties = inferProperties;
        }

        @Override
        public FlagsEntry flags() {
            return this.entry;
        }

        public void setEntry(FlagsEntry entry) {
            this.entry = entry;
        }
    }

    public static interface Data
    extends PlotterData {
        public BlockState infer(BlockState var1);

        public FlagsEntry flags();
    }
}

