/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter;

import bottomtextdanny.braincell.base.function.IntTriFunction;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.block.state.properties.WallSide;

public final class PlotterRotator {
    private static final List<IntTriFunction<BlockPos>> ROTATED_OF = List.of((x, y, z) -> new BlockPos(x, y, z), (x, y, z) -> new BlockPos(-z, y, x), (x, y, z) -> new BlockPos(-x, y, -z), (x, y, z) -> new BlockPos(z, y, -x));
    private static final List<Consumer<BlockPos.MutableBlockPos>> ROTATE = List.of(bp -> {}, bp -> bp.m_122178_(-bp.m_123343_(), bp.m_123342_(), bp.m_123341_()), bp -> bp.m_122178_(-bp.m_123341_(), bp.m_123342_(), -bp.m_123343_()), bp -> bp.m_122178_(bp.m_123343_(), bp.m_123342_(), -bp.m_123341_()));
    public static final List<Function<Rotation, Direction.Axis>> AXIS_ROTATOR = List.of(rot -> rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90 ? Direction.Axis.Z : Direction.Axis.X, rot -> Direction.Axis.Y, rot -> rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90 ? Direction.Axis.X : Direction.Axis.Z);
    private static final Map<Property<?>, BiFunction<Rotation, BlockState, BlockState>> PROPERTY_ROTATOR = (Map)Util.m_137537_(() -> {
        HashMap map = Maps.newHashMap();
        map.put(BlockStateProperties.f_61365_, (rot, bs) -> PlotterRotator.solveAxisProperty((EnumProperty<Direction.Axis>)BlockStateProperties.f_61365_, rot, bs));
        map.put(BlockStateProperties.f_61364_, (rot, bs) -> PlotterRotator.solveAxisProperty((EnumProperty<Direction.Axis>)BlockStateProperties.f_61364_, rot, bs));
        map.put(BlockStateProperties.f_61372_, (rot, bs) -> PlotterRotator.solveDirectionProperty(BlockStateProperties.f_61372_, rot, bs));
        map.put(BlockStateProperties.f_61373_, (rot, bs) -> PlotterRotator.solveDirectionProperty(BlockStateProperties.f_61373_, rot, bs));
        map.put(BlockStateProperties.f_61374_, (rot, bs) -> PlotterRotator.solveDirectionProperty(BlockStateProperties.f_61374_, rot, bs));
        map.put(BlockStateProperties.f_61390_, (rot, bs) -> {
            int val = (Integer)bs.m_61143_((Property)BlockStateProperties.f_61390_);
            return (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rot.m_55949_(val, 16)));
        });
        return map;
    });
    private static final List<BooleanProperty> SIMPLE_DIR_PROP = List.of(BlockStateProperties.f_61368_, BlockStateProperties.f_61369_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_);
    private static final List<Property<RedstoneSide>> REDSTONE_DIR_PROP = List.of(BlockStateProperties.f_61383_, BlockStateProperties.f_61382_, BlockStateProperties.f_61384_, BlockStateProperties.f_61385_);
    private static final List<Property<WallSide>> WALL_DIR_PROP = List.of(BlockStateProperties.f_61379_, BlockStateProperties.f_61378_, BlockStateProperties.f_61380_, BlockStateProperties.f_61381_);

    public static BlockPos rotatedOf(Rotation rotation, Vec3i pos) {
        return ROTATED_OF.get(rotation.ordinal()).apply(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static BlockPos rotatedOf(Rotation rotation, int x, int y, int z) {
        return ROTATED_OF.get(rotation.ordinal()).apply(x, y, z);
    }

    public static void rotate(Rotation rotation, BlockPos.MutableBlockPos pos) {
        ROTATE.get(rotation.ordinal()).accept(pos);
    }

    public static BlockState rotateBlockState(Rotation rotation, BlockState blockState) {
        for (Property property : blockState.m_61147_()) {
            BiFunction<Rotation, BlockState, BlockState> rotatorFunc = PROPERTY_ROTATOR.get(property);
            if (rotatorFunc == null) continue;
            blockState = rotatorFunc.apply(rotation, blockState);
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61368_)) {
            blockState = PlotterRotator.solveSingleDirectionProperties(SIMPLE_DIR_PROP, rotation, blockState);
        } else if (blockState.m_61138_((Property)BlockStateProperties.f_61379_)) {
            blockState = PlotterRotator.solveSingleDirectionProperties(WALL_DIR_PROP, rotation, blockState);
        } else if (blockState.m_61138_((Property)BlockStateProperties.f_61383_)) {
            blockState = PlotterRotator.solveSingleDirectionProperties(REDSTONE_DIR_PROP, rotation, blockState);
        }
        return blockState;
    }

    private static BlockState solveAxisProperty(EnumProperty<Direction.Axis> axisProp, Rotation rot, BlockState bs) {
        return (BlockState)bs.m_61124_(axisProp, (Comparable)AXIS_ROTATOR.get(((Direction.Axis)bs.m_61143_(axisProp)).ordinal()).apply(rot));
    }

    private static BlockState solveDirectionProperty(DirectionProperty dirProp, Rotation rot, BlockState bs) {
        return (BlockState)bs.m_61124_((Property)dirProp, (Comparable)rot.m_55954_((Direction)bs.m_61143_((Property)dirProp)));
    }

    private static <V extends Comparable<V>> BlockState solveSingleDirectionProperties(List<? extends Property<V>> propertyList, Rotation rot, BlockState bs) {
        Comparable north = bs.m_61143_(propertyList.get(0));
        Comparable east = bs.m_61143_(propertyList.get(1));
        Comparable south = bs.m_61143_(propertyList.get(2));
        Comparable west = bs.m_61143_(propertyList.get(3));
        Comparable rNorth = north;
        Comparable rEast = east;
        Comparable rSouth = south;
        Comparable rWest = west;
        switch (rot) {
            case CLOCKWISE_90: {
                rNorth = west;
                rEast = north;
                rSouth = east;
                rWest = south;
                break;
            }
            case CLOCKWISE_180: {
                rNorth = south;
                rEast = west;
                rSouth = north;
                rWest = east;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                rNorth = east;
                rEast = south;
                rSouth = west;
                rWest = north;
                break;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)bs.m_61124_(propertyList.get(0), rNorth)).m_61124_(propertyList.get(1), rEast)).m_61124_(propertyList.get(2), rSouth)).m_61124_(propertyList.get(3), rWest);
    }
}

