/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter;

import bottomtextdanny.braincell.mod._base.plotter.IntPlane;
import bottomtextdanny.braincell.mod._base.plotter.Plotter;
import bottomtextdanny.braincell.mod._base.plotter.PlotterRotator;
import bottomtextdanny.braincell.mod._base.plotter.SpecialPlotter;
import bottomtextdanny.braincell.mod._base.plotter.iterator.MutablePlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterIterator;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class PlanePlotter
extends SpecialPlotter<Data> {
    protected final IntPlane plane;

    public PlanePlotter(LevelAccessor level, IntPlane plane) {
        super(level);
        this.plane = plane;
    }

    public IntPlane getPlane() {
        return this.plane;
    }

    @Override
    public void makeOwnThing(BlockPos pos, PlotterIterator<Data> iterator, Rotation rotation) {
        MuData data = new MuData(this, this.plane, null, null, null, null, NT_RANDOM);
        BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos localPos = new BlockPos.MutableBlockPos();
        if (rotation != Rotation.NONE) {
            this.plane.iteratePlane((xl, yl) -> {
                localPos.m_122190_(IntPlane.FIXER_BY_AXIS.get(this.plane.getAxis().ordinal()).apply(xl, yl));
                PlotterRotator.rotate(rotation, localPos);
                worldPos.m_122178_(pos.m_123341_() + localPos.m_123341_(), pos.m_123342_() + localPos.m_123342_(), pos.m_123343_() + localPos.m_123343_());
                BlockState state = this.level.m_8055_((BlockPos)worldPos);
                data.setProg(xl - this.plane.x1, yl - this.plane.y1);
                data.setState(state);
                data.setOriginalState(state);
                data.setLocalPos((BlockPos)localPos);
                data.setBlockPos((BlockPos)worldPos);
                iterator.accept(data);
                this.level.m_7731_((BlockPos)worldPos, PlotterRotator.rotateBlockState(rotation, data.state()), 3);
            });
        } else {
            this.plane.iteratePlane((xl, yl) -> {
                localPos.m_122190_(IntPlane.FIXER_BY_AXIS.get(this.plane.getAxis().ordinal()).apply(xl, yl));
                worldPos.m_122178_(pos.m_123341_() + localPos.m_123341_(), pos.m_123342_() + localPos.m_123342_(), pos.m_123343_() + localPos.m_123343_());
                BlockState state = this.level.m_8055_((BlockPos)worldPos);
                data.setProg(xl - this.plane.x1, yl - this.plane.y1);
                data.setState(state);
                data.setOriginalState(state);
                data.setLocalPos((BlockPos)localPos);
                data.setBlockPos((BlockPos)worldPos);
                iterator.accept(data);
                this.level.m_7731_((BlockPos)worldPos, data.state(), 3);
            });
        }
    }

    private static class MuData
    extends MutablePlotterData
    implements Data {
        private final IntPlane plane;
        private int xProg;
        private int yProg;

        public MuData(Plotter<?> plotter, IntPlane plane, BlockState state, BlockState originalState, BlockPos blockPos, BlockPos localPos, RandomGenerator random) {
            super(plotter, state, originalState, blockPos, localPos, random);
            this.plane = plane;
        }

        public void setProg(int x, int y) {
            this.xProg = x;
            this.yProg = y;
        }

        @Override
        public IntPlane plane() {
            return this.plane;
        }

        @Override
        public int xProg() {
            return this.xProg;
        }

        @Override
        public int yProg() {
            return this.yProg;
        }
    }

    public static interface Data
    extends PlotterData {
        public IntPlane plane();

        public int xProg();

        public int yProg();
    }
}

