/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter;

import bottomtextdanny.braincell.base.function.IntTriFunction;
import bottomtextdanny.braincell.mod._base.plotter.DeferredPlotter;
import bottomtextdanny.braincell.mod._base.plotter.PlotterExtras;
import bottomtextdanny.braincell.mod._base.plotter.PlotterRotator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public final class DeferredPlotters {
    public static DeferredPlotter.CacheHandler<PillarCache> pillarUntilBlocked(Direction dir, Predicate<BlockPos> predicate, int stopAt, int off1s, int off2s, int off1e, int off2e) {
        return new DeferredPlotter.CacheHandler<PillarCache>((rot, root, level) -> {
            Direction direction = rot.m_55954_(dir);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            Direction.Axis axis = direction.m_122434_();
            IntTriFunction<BlockPos> axisPosGetter = PlotterExtras.AXIS_POS_GETTER.get(axis.ordinal());
            int[][] cacheMatrix = new int[off1e - off1s + 1][off2e - off2s + 1];
            int maxHeight = 0;
            for (int offset1 = off1s; offset1 <= off1e; ++offset1) {
                for (int offset2 = off2s; offset2 <= off2e; ++offset2) {
                    BlockPos rotated = PlotterRotator.rotatedOf(rot, (Vec3i)new BlockPos(offset1, 0, offset2));
                    pos.m_122190_((Vec3i)root.m_141952_((Vec3i)axisPosGetter.apply(0, rotated.m_123341_(), rotated.m_123343_())));
                    while (predicate.test((BlockPos)pos) && cacheMatrix[offset1][offset2] <= stopAt) {
                        int height;
                        int[] nArray = cacheMatrix[offset1];
                        int n = offset2;
                        nArray[n] = nArray[n] + 1;
                        if (maxHeight < height) {
                            maxHeight = height;
                        }
                        pos.m_122190_((Vec3i)pos.m_122173_(direction));
                    }
                }
            }
            return new PillarCache(axis, cacheMatrix, maxHeight);
        }, (rotator, iterator, cache) -> {
            PlotterExtras.AxisPosSetter axisPosSetter = PlotterExtras.AXIS_POS_SETTER.get(cache.axis.ordinal());
            BlockPos.MutableBlockPos posHolder = new BlockPos.MutableBlockPos();
            int step = dir.m_122421_().m_122540_();
            for (int offset1 = off1s; offset1 <= off1e; ++offset1) {
                for (int offset2 = off2s; offset2 <= off2e; ++offset2) {
                    int min;
                    int length = (cache.lengthMatrix[offset1][offset2] - 1) * step;
                    int max = Math.max(length, 0);
                    for (int axisCoord = min = Math.min(length, 0); axisCoord <= max; ++axisCoord) {
                        axisPosSetter.accept(posHolder, axisCoord, offset1, offset2);
                        iterator.accept(posHolder.m_123341_(), posHolder.m_123342_(), posHolder.m_123343_());
                    }
                }
            }
        });
    }

    public record PillarCache(Direction.Axis axis, int[][] lengthMatrix, int maxHeight) {
    }
}

