/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.plotter;

import bottomtextdanny.braincell.mod._base.plotter.IntBox;
import bottomtextdanny.braincell.mod._base.plotter.Plotter;
import bottomtextdanny.braincell.mod._base.plotter.PlotterRotator;
import bottomtextdanny.braincell.mod._base.plotter.SpecialPlotter;
import bottomtextdanny.braincell.mod._base.plotter.iterator.MutablePlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterIterator;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class BoxPlotter
extends SpecialPlotter<Data> {
    protected final IntBox box;

    public BoxPlotter(LevelAccessor level, IntBox box) {
        super(level);
        this.box = box;
    }

    public IntBox getBox() {
        return this.box;
    }

    @Override
    public void makeOwnThing(BlockPos pos, PlotterIterator<Data> iterator, Rotation rotation) {
        MuData data = new MuData(this, this.box, null, null, null, null, NT_RANDOM);
        BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos localPos = new BlockPos.MutableBlockPos();
        if (rotation != Rotation.NONE) {
            this.box.iterate((x, y, z) -> {
                localPos.m_122178_(x, y, z);
                PlotterRotator.rotate(rotation, localPos);
                worldPos.m_122178_(pos.m_123341_() + localPos.m_123341_(), pos.m_123342_() + localPos.m_123342_(), pos.m_123343_() + localPos.m_123343_());
                BlockState state = this.level.m_8055_((BlockPos)worldPos);
                data.setProg(x - this.box.x1, y - this.box.y1, z - this.box.z1);
                data.setState(state);
                data.setOriginalState(state);
                data.setLocalPos((BlockPos)localPos);
                data.setBlockPos((BlockPos)worldPos);
                iterator.accept(data);
                this.level.m_7731_((BlockPos)worldPos, PlotterRotator.rotateBlockState(rotation, data.state()), 3);
            });
        } else {
            this.box.iterate((x, y, z) -> {
                localPos.m_122178_(x, y, z);
                worldPos.m_122178_(pos.m_123341_() + localPos.m_123341_(), pos.m_123342_() + localPos.m_123342_(), pos.m_123343_() + localPos.m_123343_());
                BlockState state = this.level.m_8055_((BlockPos)worldPos);
                data.setProg(x - this.box.x1, y - this.box.y1, z - this.box.z1);
                data.setState(state);
                data.setOriginalState(state);
                data.setLocalPos((BlockPos)localPos);
                data.setBlockPos((BlockPos)worldPos);
                iterator.accept(data);
                this.level.m_7731_((BlockPos)worldPos, data.state(), 3);
            });
        }
    }

    private static class MuData
    extends MutablePlotterData
    implements Data {
        private final IntBox box;
        private int xProg;
        private int yProg;
        private int zProg;

        public MuData(Plotter<?> plotter, IntBox box, BlockState state, BlockState originalState, BlockPos blockPos, BlockPos localPos, RandomGenerator random) {
            super(plotter, state, originalState, blockPos, localPos, random);
            this.box = box;
        }

        public void setProg(int x, int y, int z) {
            this.xProg = x;
            this.yProg = y;
            this.zProg = z;
        }

        @Override
        public IntBox box() {
            return this.box;
        }

        @Override
        public int xProg() {
            return this.xProg;
        }

        @Override
        public int yProg() {
            return this.yProg;
        }

        @Override
        public int zProg() {
            return this.zProg;
        }
    }

    public static interface Data
    extends PlotterData {
        public IntBox box();

        public int xProg();

        public int yProg();

        public int zProg();
    }
}

