/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.opengl;

import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.mod._base.opengl.GLProgram;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL43;

@OnlyIn(value=Dist.CLIENT)
public final class UniformManager {
    private final Map<Integer, int[]> uniformArrayDirMap = Maps.newHashMap();
    private final Object2IntOpenHashMap<String> uniformDirMap = new Object2IntOpenHashMap();
    private final GLProgram<?> program;

    public UniformManager(GLProgram<?> program, Pair<String, Integer> ... arraySizes) {
        this.program = program;
        if (arraySizes.length > 0) {
            int bracketIndex = arraySizes[0].left().indexOf(91);
            for (int i = 0; i < arraySizes.length; ++i) {
                int size = arraySizes[i].right();
                int[] array = new int[size];
                String name = arraySizes[i].left();
                String firstPart = name.substring(0, bracketIndex + 1);
                String secondPart = name.substring(bracketIndex + 1);
                for (int j = 0; j < size; ++j) {
                    array[j] = GL43.glGetUniformLocation((int)program.getProgramID(), (CharSequence)(firstPart + j + secondPart));
                }
                this.uniformArrayDirMap.put(i, array);
            }
        }
    }

    public int[] retrieveLocations(int pointer) {
        return this.uniformArrayDirMap.get(pointer);
    }

    public int retrieveLocation(String str) {
        if (!this.uniformDirMap.containsKey((Object)str)) {
            int newLoc = GL43.glGetUniformLocation((int)this.program.getProgramID(), (CharSequence)str);
            this.uniformDirMap.put((Object)str, newLoc);
            return newLoc;
        }
        return this.uniformDirMap.getOrDefault((Object)str, -1);
    }
}

