/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.opengl;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.opengl.GLProgram;
import bottomtextdanny.braincell.mod._base.opengl.ShaderWorkflow;
import bottomtextdanny.braincell.mod._base.opengl.enums.ShaderType;
import com.mojang.math.Matrix4f;
import java.util.EnumMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class PixelProgram<WF extends ShaderWorkflow>
extends GLProgram<WF> {
    protected static final String PROJ_MATRIX_NAME = "proj_mat";
    protected static final String MODEL_VIEW_MATRIX_NAME = "mv_mat";
    protected static final String SCREN_SIZE_NAME = "screen";
    public final EnumMap<ShaderType, ResourceLocation> shaderSourceMap = new EnumMap(ShaderType.class);

    public PixelProgram(WF workflow, ResourceLocation key) {
        super(workflow, key);
        try {
            boolean geomFlag;
            ResourceLocation vertexPath = new ResourceLocation(key.m_135827_(), "shaders/vertex/" + key.m_135815_() + ".vert");
            ResourceLocation fragmentPath = new ResourceLocation(key.m_135827_(), "shaders/fragment/" + key.m_135815_() + ".frag");
            ResourceLocation geometryPath = new ResourceLocation(key.m_135827_(), "shaders/geometry/" + key.m_135815_() + ".geom");
            String vertexSource = this.prepareResource(vertexPath, ShaderType.VERTEX);
            String fragmentSource = this.prepareResource(fragmentPath, ShaderType.FRAGMENT);
            String geometrySource = this.prepareResource(geometryPath, ShaderType.GEOMETRY);
            this.shaderSourceMap.put(ShaderType.VERTEX, vertexPath);
            this.shaderSourceMap.put(ShaderType.FRAGMENT, fragmentPath);
            int vertexID = PixelProgram.createShader(ShaderType.VERTEX);
            int fragmentID = PixelProgram.createShader(ShaderType.FRAGMENT);
            int geometryID = -1;
            this.compileShader(vertexID, vertexSource);
            this.compileShader(fragmentID, fragmentSource);
            this.validateShader(vertexID);
            this.validateShader(fragmentID);
            boolean bl = geomFlag = geometrySource != null;
            if (geomFlag) {
                this.shaderSourceMap.put(ShaderType.GEOMETRY, geometryPath);
                geometryID = PixelProgram.createShader(ShaderType.GEOMETRY);
                this.compileShader(geometryID, geometrySource);
                this.attachShader(geometryID);
                this.validateShader(geometryID);
            }
            this.attachShader(vertexID);
            this.attachShader(fragmentID);
            this.linkProgram();
            this.validateProgram();
            if (geomFlag) {
                PixelProgram.deleteShader(geometryID);
            }
            PixelProgram.deleteShader(vertexID, fragmentID);
            this.uniformManager = this.createUniformManager();
        }
        catch (Exception ex) {
            Braincell.client().logger.error("failed to generate pixel program object, key:{}", (Object)this.getKey());
            ex.printStackTrace();
        }
    }

    @Override
    public void flow() {
        this.useProgram();
        this.uMatrix(PROJ_MATRIX_NAME, Matrix4f.m_27636_((float)PixelProgram.mc().m_91268_().m_85441_(), (float)(-PixelProgram.mc().m_91268_().m_85442_()), (float)1000.0f, (float)3000.0f));
        this.uVector2(SCREN_SIZE_NAME, (float)PixelProgram.mc().m_91268_().m_85441_(), (float)PixelProgram.mc().m_91268_().m_85442_());
        this.renderSpace();
        this.clearProgram();
    }
}

