/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.opengl;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.braincell.mod._base.opengl.ShaderBuffer;
import bottomtextdanny.braincell.mod._base.opengl.ShaderWorkflow;
import bottomtextdanny.braincell.mod._base.opengl.UniformManager;
import bottomtextdanny.braincell.mod._base.opengl.enums.ShaderType;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL43;

@OnlyIn(value=Dist.CLIENT)
public abstract class GLProgram<WF extends ShaderWorkflow> {
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final RenderTarget MAIN_TARGET = Minecraft.m_91087_().m_91385_();
    protected final WF workflow;
    protected int programID;
    private final ResourceLocation key;
    protected UniformManager uniformManager;
    private int layoutOffset;

    public GLProgram(WF workflow, ResourceLocation key) {
        this.key = key;
        this.creation();
        this.workflow = workflow;
    }

    private void creation() {
        this.programID = GL43.glCreateProgram();
        System.out.println("id " + this.programID + " created for program " + this.key);
    }

    protected void validateProgram() {
        int isLinked = GL43.glGetProgrami((int)this.programID, (int)35714);
        if (isLinked == 0) {
            int length = GL43.glGetProgrami((int)this.programID, (int)35716);
            Braincell.client().logger.warn("Braincell '{}' program error: {}", (Object)this.key, (Object)GL43.glGetProgramInfoLog((int)this.programID));
            GL43.glDeleteProgram((int)this.programID);
            ((ShaderWorkflow)this.workflow).invalidate();
        }
    }

    protected void validateShader(int shaderID) {
        int status = GL43.glGetShaderi((int)shaderID, (int)35713);
        if (status == 0) {
            String log = GL43.glGetShaderInfoLog((int)shaderID);
            if (log.isEmpty()) {
                Braincell.client().logger.warn("Braincell '{}' shader error, no log provided", (Object)this.key);
            } else {
                Braincell.client().logger.warn("Braincell '{}' shader error: {}", (Object)this.key, (Object)log);
            }
            GL43.glDeleteProgram((int)this.programID);
            ((ShaderWorkflow)this.workflow).invalidate();
        }
    }

    public UniformManager createUniformManager() {
        return new UniformManager(this, new Pair[0]);
    }

    public abstract void flow();

    public void finish() {
        this.clearProgram();
    }

    protected abstract void renderSpace();

    public void useProgram() {
        GL43.glUseProgram((int)this.programID);
    }

    public void clearProgram() {
        GL43.glUseProgram((int)0);
        this.layoutOffset = 0;
    }

    protected void attachShader(int shaderID) {
        if (!((ShaderWorkflow)this.workflow).isInvalid()) {
            GL43.glAttachShader((int)this.programID, (int)shaderID);
        }
    }

    public void linkProgram() {
        GL43.glLinkProgram((int)this.programID);
    }

    public void reset() {
        GL43.glUseProgram((int)0);
        GL43.glDeleteProgram((int)this.programID);
        this.layoutOffset = 0;
    }

    public int getProgramID() {
        return this.programID;
    }

    protected static int createShader(ShaderType type) {
        return GL43.glCreateShader((int)type.getAsInt());
    }

    protected static void deleteShader(int ... shaderIDs) {
        for (int shaderID : shaderIDs) {
            GL43.glDeleteShader((int)shaderID);
        }
    }

    protected void compileShader(int shaderID, String source) {
        if (!((ShaderWorkflow)this.workflow).isInvalid() && source != null) {
            GL43.glShaderSource((int)shaderID, (CharSequence)source);
            GL43.glCompileShader((int)shaderID);
        }
    }

    @Nullable
    protected String prepareResource(ResourceLocation fileName, ShaderType shaderType) {
        String source = this.source(fileName);
        if (source == null) {
            return null;
        }
        String[] supplies = this.getSourceTransformers(shaderType);
        if (supplies != null) {
            int iterations = supplies.length % 2 == 1 ? supplies.length - 1 : supplies.length;
            for (int i = 0; i < iterations; i += 2) {
                String hook = supplies[i];
                String supply = supplies[i + 1];
                source = source.replaceAll(hook, supply);
            }
        }
        return source;
    }

    @Nullable
    protected String[] getSourceTransformers(ShaderType type) {
        return null;
    }

    protected String source(ResourceLocation fileName) {
        try {
            StringWriter strBuf = new StringWriter();
            IOUtils.copy((InputStream)Minecraft.m_91087_().m_91098_().m_142591_(fileName).m_6679_(), (Writer)strBuf, (String)"UTF-8");
            return strBuf.toString();
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    protected void bindBuffer(ShaderBuffer buffer) {
        GL43.glBindBuffer((int)37074, (int)buffer.getId());
        GL43.glBindBufferBase((int)37074, (int)this.layoutOffset, (int)buffer.getId());
        ++this.layoutOffset;
    }

    protected void uTextureBinding(String location, int textureID) {
        GlStateManager.m_84538_((int)(33984 + this.layoutOffset));
        GlStateManager.m_84109_();
        GlStateManager.m_84544_((int)textureID);
        GL43.glUniform1i((int)this.uniformManager.retrieveLocation(location), (int)this.layoutOffset);
        GlStateManager.m_84110_();
        GlStateManager.m_84538_((int)33984);
        ++this.layoutOffset;
    }

    protected void uBoolean(String location, boolean value) {
        GL43.glUniform1i((int)this.uniformManager.retrieveLocation(location), (int)(value ? 1 : 0));
    }

    protected void uInteger(String location, int value) {
        GL43.glUniform1i((int)this.uniformManager.retrieveLocation(location), (int)value);
    }

    protected void uFloat(String location, float value) {
        GL43.glUniform1f((int)this.uniformManager.retrieveLocation(location), (float)value);
    }

    protected void uMatrix(String location, Matrix4f value) {
        FloatBuffer buf = FloatBuffer.allocate(16);
        value.m_27650_(buf);
        GL20.glUniformMatrix4fv((int)this.uniformManager.retrieveLocation(location), (boolean)false, (float[])buf.array());
    }

    protected void uMatrix(String location, float[] value) {
        GL43.glUniformMatrix4fv((int)this.uniformManager.retrieveLocation(location), (boolean)false, (float[])value);
    }

    protected void uVector4(String location, Vec3 value, float w) {
        GL43.glUniform4f((int)this.uniformManager.retrieveLocation(location), (float)((float)value.f_82479_), (float)((float)value.f_82480_), (float)((float)value.f_82481_), (float)w);
    }

    protected void uVector4(String location, float[] value) {
        GL43.glUniform4f((int)this.uniformManager.retrieveLocation(location), (float)value[0], (float)value[1], (float)value[2], (float)value[3]);
    }

    protected void uVector3(String location, Vec3 value) {
        GL43.glUniform3f((int)this.uniformManager.retrieveLocation(location), (float)((float)value.f_82479_), (float)((float)value.f_82480_), (float)((float)value.f_82481_));
    }

    protected void uVector3(String location, Vector3f value) {
        GL43.glUniform3f((int)this.uniformManager.retrieveLocation(location), (float)value.m_122239_(), (float)value.m_122260_(), (float)value.m_122269_());
    }

    protected void uVector2(String location, float x, float y) {
        GL43.glUniform2f((int)this.uniformManager.retrieveLocation(location), (float)x, (float)y);
    }

    protected void uBoolean(String location, boolean value, int arrayPos) {
        GL43.glUniform1i((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (int)(value ? 1 : 0));
    }

    protected void uInteger(String location, int value, int arrayPos) {
        GL43.glUniform1i((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (int)value);
    }

    protected void uFloat(String location, float value, int arrayPos) {
        GL43.glUniform1f((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (float)value);
    }

    protected void uMatrix(String location, Matrix4f value, int arrayPos) {
        FloatBuffer buf = FloatBuffer.allocate(16);
        value.m_27650_(buf);
        GL20.glUniformMatrix4fv((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (boolean)false, (float[])buf.array());
    }

    protected void uMatrix(String location, float[] value, int arrayPos) {
        GL43.glUniformMatrix4fv((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (boolean)false, (float[])value);
    }

    protected void uVector4(String location, Vec3 value, float w, int arrayPos) {
        GL43.glUniform4f((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (float)((float)value.f_82479_), (float)((float)value.f_82480_), (float)((float)value.f_82481_), (float)w);
    }

    protected void uVector3(String location, Vec3 value, int arrayPos) {
        GL43.glUniform3f((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (float)((float)value.f_82479_), (float)((float)value.f_82480_), (float)((float)value.f_82481_));
    }

    protected void uVector3(String location, Vector3f value, int arrayPos) {
        GL43.glUniform3f((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (float)value.m_122239_(), (float)value.m_122260_(), (float)value.m_122269_());
    }

    protected void uVector2(String location, float x, float y, int arrayPos) {
        GL43.glUniform2f((int)this.uniformManager.retrieveLocation(location + String.valueOf(new char[]{'[', Character.forDigit(arrayPos, 10), ']'})), (float)x, (float)y);
    }

    protected void uBoolean(int location, boolean value) {
        GL43.glUniform1i((int)location, (int)(value ? 1 : 0));
    }

    protected void uInteger(int location, int value) {
        GL43.glUniform1i((int)location, (int)value);
    }

    protected void uFloat(int location, float value) {
        GL43.glUniform1f((int)location, (float)value);
    }

    protected void uMatrix(int location, Matrix4f value) {
        FloatBuffer buf = FloatBuffer.allocate(16);
        value.m_27650_(buf);
        GL20.glUniformMatrix4fv((int)location, (boolean)false, (float[])buf.array());
    }

    protected void uMatrix(int location, float[] value) {
        GL43.glUniformMatrix4fv((int)location, (boolean)false, (float[])value);
    }

    protected void uVector4(int location, Vec3 value, float w) {
        GL43.glUniform4f((int)location, (float)((float)value.f_82479_), (float)((float)value.f_82480_), (float)((float)value.f_82481_), (float)w);
    }

    protected void uVector3(int location, Vec3 value) {
        GL43.glUniform3f((int)location, (float)((float)value.f_82479_), (float)((float)value.f_82480_), (float)((float)value.f_82481_));
    }

    protected void uVector3(int location, Vector3f value) {
        GL43.glUniform3f((int)location, (float)value.m_122239_(), (float)value.m_122260_(), (float)value.m_122269_());
    }

    protected void uVector2(int location, float x, float y) {
        GL43.glUniform2f((int)location, (float)x, (float)y);
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    public static RenderTarget mainTarget() {
        return Minecraft.m_91087_().m_91385_();
    }

    public static void renderScreenQuad() {
        Minecraft mc = Minecraft.m_91087_();
        int widthP = mc.m_91385_().f_83915_;
        int heightP = mc.m_91385_().f_83916_;
        GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager.m_84507_();
        GlStateManager.m_84298_((boolean)false);
        GlStateManager.m_84430_((int)0, (int)0, (int)widthP, (int)heightP);
        GlStateManager.m_84519_();
        Matrix4f matrix4f = Matrix4f.m_27636_((float)widthP, (float)(-heightP), (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        float f = widthP;
        float f1 = heightP;
        Tesselator tesselator = RenderSystem.m_69883_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, (double)f1, 0.0).m_6122_(255, 255, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)f, (double)f1, 0.0).m_6122_(255, 255, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)f, 0.0, 0.0).m_6122_(255, 255, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, 0.0).m_6122_(255, 0, 255, 255).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_166847_((BufferBuilder)bufferbuilder);
        GlStateManager.m_84298_((boolean)true);
        GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

