/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.opengl;

import bottomtextdanny.braincell.Braincell;
import bottomtextdanny.braincell.mod._base.opengl.GLProgram;
import bottomtextdanny.braincell.mod._base.opengl.ShaderWorkflow;
import bottomtextdanny.braincell.mod._base.opengl.enums.ShaderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL43;

@OnlyIn(value=Dist.CLIENT)
public abstract class ComputationProgram<WF extends ShaderWorkflow>
extends GLProgram<WF> {
    private int xThreads;
    private int yThreads;
    private int zThreads;
    private ResourceLocation shaderSource;

    public ComputationProgram(int xThreads, int yThreads, int zThreads, WF workflow, ResourceLocation key) {
        super(workflow, key);
        try {
            this.xThreads = xThreads;
            this.yThreads = yThreads;
            this.zThreads = zThreads;
            ResourceLocation computationPath = new ResourceLocation(key.m_135827_(), "shaders/computation/" + key.m_135815_() + ".comp");
            String computationSource = this.prepareResource(computationPath, ShaderType.COMPUTATION);
            this.shaderSource = computationPath;
            int computationID = ComputationProgram.createShader(ShaderType.COMPUTATION);
            this.compileShader(computationID, computationSource);
            this.validateShader(computationID);
            this.attachShader(computationID);
            this.linkProgram();
            this.validateProgram();
            ComputationProgram.deleteShader(computationID);
            this.uniformManager = this.createUniformManager();
        }
        catch (Exception ex) {
            Braincell.client().logger.error("failed to generate compute program object, key:{}", (Object)this.getKey());
            ex.printStackTrace();
        }
    }

    public int getXThreads() {
        return this.xThreads;
    }

    public int getYThreads() {
        return this.yThreads;
    }

    public int getZThreads() {
        return this.zThreads;
    }

    public ResourceLocation getShaderSource() {
        return this.shaderSource;
    }

    @Override
    public void useProgram() {
        GL20.glUseProgram((int)this.programID);
    }

    protected void dispatchProgram() {
        GL43.glDispatchCompute((int)this.xThreads, (int)this.yThreads, (int)this.zThreads);
    }

    @Override
    public void flow() {
        this.useProgram();
        this.renderSpace();
        this.clearProgram();
    }
}

