/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.blitty.renderer;

import bottomtextdanny.braincell.mod._base.blitty.Blitty;
import bottomtextdanny.braincell.mod._base.blitty.BlittyConfig;
import bottomtextdanny.braincell.mod._base.blitty.color_data.BlittyColor;
import bottomtextdanny.braincell.mod._base.blitty.pos_data.BlittyPos;
import bottomtextdanny.braincell.mod._base.blitty.renderer.BlittyRenderer;
import bottomtextdanny.braincell.mod._base.blitty.uv_data.BlittyUV;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.GameRenderer;

public class BlittyQuadRenderer
implements BlittyRenderer {
    public static final BlittyQuadRenderer INSTANCE = new BlittyQuadRenderer();

    @Override
    public void render(Blitty blitty, PoseStack matrixStack, float posX, float posY, float posZ, BlittyConfig ... configurations) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float widthBy2 = (float)blitty.width() / 2.0f;
        float heightBy2 = (float)blitty.width() / 2.0f;
        BlittyPos posTopLeft = new BlittyPos(0.0f, 0.0f, -1.0f, -1.0f);
        BlittyPos posTopRight = new BlittyPos(1.0f, 0.0f, 1.0f, -1.0f);
        BlittyPos posBottomLeft = new BlittyPos(0.0f, 1.0f, -1.0f, 1.0f);
        BlittyPos posBottomRight = new BlittyPos(1.0f, 1.0f, 1.0f, 1.0f);
        posX += widthBy2;
        posY += heightBy2;
        BlittyUV uv = new BlittyUV(blitty.image(), blitty.x(), blitty.y(), blitty.width(), blitty.height());
        if (BlittyRenderer.modsColor(configurations)) {
            BlittyColor colorTopLeft = new BlittyColor(0.0f, 0.0f);
            BlittyColor colorTopRight = new BlittyColor(1.0f, 0.0f);
            BlittyColor colorBottomLeft = new BlittyColor(0.0f, 1.0f);
            BlittyColor colorBottomRight = new BlittyColor(1.0f, 1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            for (BlittyConfig configuration : configurations) {
                configuration.start(blitty);
                configuration.vertex(blitty, colorTopLeft, posTopLeft);
                configuration.vertex(blitty, colorTopRight, posTopRight);
                configuration.vertex(blitty, colorBottomLeft, posBottomLeft);
                configuration.vertex(blitty, colorBottomRight, posBottomRight);
                configuration.finish(blitty, uv);
            }
            float uvXStart = uv.x / (float)blitty.image().width();
            float uvYStart = uv.y / (float)blitty.image().height();
            float uvXEnd = (uv.x + uv.width) / (float)blitty.image().width();
            float uvYEnd = (uv.y + uv.height) / (float)blitty.image().height();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            BlittyColor currentColor = colorBottomLeft;
            bufferbuilder.m_85982_(matrix, posX + posBottomLeft.x * widthBy2, posY + posBottomLeft.y * widthBy2, posZ).m_7421_(uvXStart, uvYEnd).m_6122_((int)currentColor.r, (int)currentColor.g, (int)currentColor.b, (int)currentColor.a).m_5752_();
            currentColor = colorBottomRight;
            bufferbuilder.m_85982_(matrix, posX + posBottomRight.x * widthBy2, posY + posBottomRight.y * widthBy2, posZ).m_7421_(uvXEnd, uvYEnd).m_6122_((int)currentColor.r, (int)currentColor.g, (int)currentColor.b, (int)currentColor.a).m_5752_();
            currentColor = colorTopRight;
            bufferbuilder.m_85982_(matrix, posX + posTopRight.x * widthBy2, posY + posTopRight.y * widthBy2, posZ).m_7421_(uvXEnd, uvYStart).m_6122_((int)currentColor.r, (int)currentColor.g, (int)currentColor.b, (int)currentColor.a).m_5752_();
            currentColor = colorTopLeft;
            bufferbuilder.m_85982_(matrix, posX + posTopLeft.x * widthBy2, posY + posTopLeft.y * widthBy2, posZ).m_7421_(uvXStart, uvYStart).m_6122_((int)currentColor.r, (int)currentColor.g, (int)currentColor.b, (int)currentColor.a).m_5752_();
            bufferbuilder.m_85721_();
        } else {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            for (BlittyConfig configuration : configurations) {
                configuration.start(blitty);
                configuration.vertex(blitty, null, posTopLeft);
                configuration.vertex(blitty, null, posTopRight);
                configuration.vertex(blitty, null, posBottomLeft);
                configuration.vertex(blitty, null, posBottomRight);
                configuration.finish(blitty, uv);
            }
            float uvXStart = uv.x / (float)blitty.image().width();
            float uvYStart = uv.y / (float)blitty.image().height();
            float uvXEnd = (uv.x + uv.width) / (float)blitty.image().width();
            float uvYEnd = (uv.y + uv.height) / (float)blitty.image().height();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_85982_(matrix, posX + posBottomLeft.x * widthBy2, posY + posBottomLeft.y * widthBy2, posZ).m_7421_(uvXStart, uvYEnd).m_5752_();
            bufferbuilder.m_85982_(matrix, posX + posBottomRight.x * widthBy2, posY + posBottomRight.y * widthBy2, posZ).m_7421_(uvXEnd, uvYEnd).m_5752_();
            bufferbuilder.m_85982_(matrix, posX + posTopRight.x * widthBy2, posY + posTopRight.y * widthBy2, posZ).m_7421_(uvXEnd, uvYStart).m_5752_();
            bufferbuilder.m_85982_(matrix, posX + posTopLeft.x * widthBy2, posY + posTopLeft.y * widthBy2, posZ).m_7421_(uvXStart, uvYStart).m_5752_();
            bufferbuilder.m_85721_();
        }
        BufferUploader.m_166847_((BufferBuilder)bufferbuilder);
    }
}

