/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.blitty;

import bottomtextdanny.braincell.mod._base.blitty.Blitty;
import bottomtextdanny.braincell.mod._base.blitty.BlittyConfig;
import bottomtextdanny.braincell.mod._base.blitty.BlittyVector;
import bottomtextdanny.braincell.mod._base.blitty.color_data.BlittyColor;
import bottomtextdanny.braincell.mod._base.blitty.pos_data.BlittyPos;
import bottomtextdanny.braincell.mod._base.blitty.uv_data.BlittyUV;
import org.jetbrains.annotations.Nullable;

public class PixelCutter
implements BlittyConfig {
    public final BlittyVector vector;
    private float pixels;

    public PixelCutter(BlittyVector vector) {
        this.vector = vector;
    }

    @Override
    public void start(Blitty blitty) {
    }

    @Override
    public void vertex(Blitty blitty, @Nullable BlittyColor color, BlittyPos position) {
        if (this.vector.usesX()) {
            float relativeTransition = (float)this.vector.x >= 0.0f ? position.transitionX : 1.0f - position.transitionX;
            float pixelRelative = relativeTransition / (float)blitty.width();
            position.x -= pixelRelative * (float)this.vector.x * this.pixels * 2.0f;
        } else if (this.vector.usesY()) {
            float relativeTransition = (float)this.vector.y >= 0.0f ? position.transitionY : 1.0f - position.transitionY;
            float pixelRelative = relativeTransition / (float)blitty.height();
            position.y -= pixelRelative * (float)this.vector.y * this.pixels * 2.0f;
        }
    }

    @Override
    public void finish(Blitty blitty, BlittyUV uv) {
        if (this.vector.usesX()) {
            if ((float)this.vector.x <= 0.0f) {
                uv.x += this.pixels;
            }
            uv.width -= this.pixels;
        } else if (this.vector.usesY()) {
            if ((float)this.vector.y <= 0.0f) {
                uv.y += this.pixels;
            }
            uv.height -= this.pixels;
        }
    }

    public void setCutoffPixels(float pixels) {
        this.pixels = pixels;
    }

    public void setCutoffPixels(int max, float normalizedPixelRange) {
        this.pixels = (float)max * normalizedPixelRange;
    }

    @Override
    public boolean usesColor() {
        return false;
    }

    @Override
    public boolean usesPos() {
        return true;
    }

    @Override
    public boolean usesUV() {
        return true;
    }
}

