/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.animation.interpreter;

import bottomtextdanny.braincell.base.function.Lazy;
import bottomtextdanny.braincell.mod._base.animation.ModelAnimator;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInstruction;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInterpreterData;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCJoint;
import bottomtextdanny.braincell.mod._base.rendering.core_modeling.BCModel;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimationInterpreter {
    private final BCModel model;
    private final Lazy<AnimationInterpreterData> data;
    private Map<Integer, BCJoint> indexedJoints;

    public AnimationInterpreter(BCModel model, Lazy<AnimationInterpreterData> data) {
        this.model = model;
        this.data = data;
    }

    public void run(ModelAnimator animator) {
        if (this.indexedJoints == null) {
            this.indexJoints();
        }
        this.data.get().runners().forEach(timedInstructions -> this.runRunner((Map<Float, List<AnimationInstruction>>)timedInstructions, animator));
    }

    private void runRunner(Map<Float, List<AnimationInstruction>> timedInstructions, ModelAnimator animator) {
        float addedTime = 0.0f;
        for (Map.Entry<Float, List<AnimationInstruction>> entry : timedInstructions.entrySet()) {
            float frame = entry.getKey().floatValue() - addedTime;
            addedTime = entry.getKey().floatValue();
            List<AnimationInstruction> instructionListed = entry.getValue();
            if (!animator.setupKeyframe(frame)) continue;
            for (AnimationInstruction instruction : instructionListed) {
                BCJoint joint = this.indexedJoints.get(instruction.index());
                if (joint == null) continue;
                instruction.actor().act(animator, joint, instruction.x(), instruction.y(), instruction.z(), instruction.easing());
            }
            animator.apply();
        }
        animator.reset();
    }

    private void indexJoints() {
        List<String> jointIdentifiers = this.data.get().jointIdentifiers();
        HashMap joints = Maps.newHashMap();
        this.model.getJoints().forEach(joint -> {
            for (int i = 0; i < jointIdentifiers.size(); ++i) {
                String identifier = (String)jointIdentifiers.get(i);
                if (!joint.name().equals(identifier)) continue;
                joints.put(i, joint);
            }
        });
        this.indexedJoints = Collections.unmodifiableMap(joints);
    }
}

