/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod._base.animation;

import bottomtextdanny.braincell.base.BCStringUtil;
import bottomtextdanny.braincell.base.Easing;
import bottomtextdanny.braincell.base.function.Lazy;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInstruction;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInstructionActor;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInterpreter;
import bottomtextdanny.braincell.mod._base.animation.interpreter.AnimationInterpreterData;
import bottomtextdanny.braincell.mod.rendering.modeling.BCEntityModel;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.IOUtils;

public class AnimationManager {
    private static final Gson JSON_ADAPTER = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Map<String, AnimationInstructionActor> INSTRUCTION_PARSER = (Map)Util.m_137537_(() -> {
        HashMap map = Maps.newHashMap();
        map.put("rotation", AnimationInstructionActor.ROTATE);
        map.put("position", AnimationInstructionActor.POSITION);
        map.put("scale", AnimationInstructionActor.SCALE);
        return Collections.unmodifiableMap(map);
    });
    private static final Map<String, Easing> EASING_PARSER = (Map)Util.m_137537_(() -> {
        HashMap map = Maps.newHashMap();
        map.put("ease_in_sine", Easing.EASE_IN_SINE);
        map.put("ease_out_sine", Easing.EASE_OUT_SINE);
        map.put("ease_in_out_sine", Easing.EASE_IN_OUT_SINE);
        map.put("ease_in_square", Easing.EASE_IN_SQUARE);
        map.put("ease_out_square", Easing.EASE_OUT_SQUARE);
        map.put("ease_in_out_square", Easing.EASE_IN_OUT_SQUARE);
        map.put("ease_in_cubic", Easing.EASE_IN_CUBIC);
        map.put("ease_out_cubic", Easing.EASE_OUT_CUBIC);
        map.put("ease_in_out_cubic", Easing.EASE_IN_OUT_CUBIC);
        map.put("ease_in_quart", Easing.EASE_IN_QUART);
        map.put("ease_out_quart", Easing.EASE_OUT_QUART);
        map.put("ease_in_out_quart", Easing.EASE_IN_OUT_QUART);
        map.put("ease_in_quint", Easing.EASE_IN_QUINT);
        map.put("ease_out_quint", Easing.EASE_OUT_QUINT);
        map.put("ease_in_out_quint", Easing.EASE_IN_OUT_QUINT);
        map.put("bounce_in", Easing.BOUNCE_IN);
        map.put("bounce_out", Easing.BOUNCE_OUT);
        map.put("bounce_in_out", Easing.BOUNCE_IN_OUT);
        return Collections.unmodifiableMap(map);
    });
    private final Map<ResourceLocation, AnimationInterpreterData> cache = Maps.newHashMapWithExpectedSize((int)512);

    public AnimationInterpreter makeInterpreter(ResourceLocation location, BCEntityModel<?> model) {
        return new AnimationInterpreter(model, Lazy.of(() -> {
            if (this.cache.containsKey(location)) {
                return this.cache.get(location);
            }
            AnimationInterpreterData newBuiltData = this.parseData(location);
            if (newBuiltData == null) {
                return AnimationInterpreterData.DUMMY;
            }
            this.cache.put(location, newBuiltData);
            return newBuiltData;
        }));
    }

    @Nullable
    private AnimationInterpreterData parseData(ResourceLocation location) {
        JsonObject jsonEquivalent;
        String extracted = this.resourceInput(new ResourceLocation(location.m_135827_(), "bc_animations/" + location.m_135815_() + ".json"));
        if (extracted == null) {
            return null;
        }
        try {
            jsonEquivalent = (JsonObject)JSON_ADAPTER.fromJson(extracted, JsonObject.class);
        }
        catch (Exception ex) {
            AnimationManager.failedParsing(location, "the file cannot be read as a json structure.");
            ex.printStackTrace();
            return null;
        }
        if (!jsonEquivalent.isJsonObject()) {
            return null;
        }
        AnimationInterpreterData data = null;
        try {
            data = this.parseJsonData(jsonEquivalent.getAsJsonArray("animation"));
        }
        catch (Exception ex) {
            AnimationManager.failedParsing(location, "the file cannot be read as animation metadata.");
        }
        return data;
    }

    private AnimationInterpreterData parseJsonData(JsonArray animationMetadata) {
        HashMap jointIdentifiersMap = Maps.newHashMap();
        ArrayList runners = Lists.newArrayList();
        for (JsonElement runnerElement : animationMetadata) {
            JsonObject runnerJson = runnerElement.getAsJsonObject();
            Map<Float, List<AnimationInstruction>> timedInstructions = this.parseRunner(str -> jointIdentifiersMap.putIfAbsent(str, jointIdentifiersMap.size()), jointIdentifiersMap, runnerJson);
            if (timedInstructions == null) continue;
            runners.add(timedInstructions);
        }
        List<String> jointIdentifiers = jointIdentifiersMap.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).toList();
        return new AnimationInterpreterData(jointIdentifiers, runners);
    }

    private Map<Float, List<AnimationInstruction>> parseRunner(Consumer<String> nameTester, Map<String, Integer> identifiersIndexed, JsonObject runnerMetadata) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Map.Entry entry : runnerMetadata.entrySet()) {
            ArrayList instructions = Lists.newArrayList();
            String frame = (String)entry.getKey();
            for (JsonElement instructionsJson : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                instructions.add(this.parseInstructions(nameTester, identifiersIndexed, instructionsJson.getAsJsonObject()));
            }
            map.putIfAbsent(Float.valueOf(Float.parseFloat(frame)), instructions);
        }
        return map;
    }

    private AnimationInstruction parseInstructions(Consumer<String> nameTester, Map<String, Integer> identifiersIndexed, JsonObject instructionsMetadata) {
        String easingIdentifier;
        List elements = instructionsMetadata.entrySet().stream().toList();
        String jointIdentifier = ((JsonElement)((Map.Entry)elements.get(0)).getValue()).getAsString();
        String instructionIdentifier = (String)((Map.Entry)elements.get(1)).getKey();
        Easing easing = null;
        nameTester.accept(jointIdentifier);
        AnimationInstructionActor actor = null;
        float[] vector = new float[3];
        int index = identifiersIndexed.get(jointIdentifier);
        if (INSTRUCTION_PARSER.containsKey(instructionIdentifier)) {
            JsonArray vectorMetadata = ((JsonElement)((Map.Entry)elements.get(1)).getValue()).getAsJsonArray();
            actor = INSTRUCTION_PARSER.get(instructionIdentifier);
            int counter = 0;
            for (JsonElement element : vectorMetadata) {
                if (counter >= 3) break;
                vector[counter] = element.getAsFloat();
                ++counter;
            }
        }
        if (instructionsMetadata.has("easing") && EASING_PARSER.containsKey(easingIdentifier = instructionsMetadata.get("easing").getAsString())) {
            easing = EASING_PARSER.get(easingIdentifier);
        }
        return new AnimationInstruction(actor, index, vector[0], vector[1], vector[2], easing);
    }

    @Nullable
    private String resourceInput(ResourceLocation location) {
        try {
            StringWriter strBuf = new StringWriter();
            IOUtils.copy((InputStream)Minecraft.m_91087_().m_91098_().m_142591_(location).m_6679_(), (Writer)strBuf, (String)"UTF-8");
            return strBuf.toString();
        }
        catch (Exception ex) {
            AnimationManager.failedParsing(location, "the file does not exist or cannot be read as text.");
            ex.printStackTrace();
            return null;
        }
    }

    private static void failedParsing(ResourceLocation filename, String message) {
        new UnexpectedException(BCStringUtil.params("Couldn't deserialize animation file at {} because {}", filename, message)).printStackTrace();
    }
}

