/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod;

import bottomtextdanny.braincell.Braincell;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.block.state.properties.Property;

public final class PropertyMap {
    private static final Map<String, Property<?>> ENTRIES = new ConcurrentHashMap(1024);

    public static void processClass(String namespace, Class<?> clazz) {
        ENTRIES.clear();
        int ch = PropertyMap.isValidNamespace(namespace);
        if (ch != -1) {
            Braincell.common().logger.error("namespace \"{}\" has invalid character at index {}", (Object)namespace, (Object)ch);
        }
        for (Field field : clazz.getFields()) {
            try {
                Object object = field.get(null);
                if (!(object instanceof Property)) continue;
                Property property = (Property)object;
                ENTRIES.put(namespace + ":" + field.getName().toLowerCase(), property);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static <T extends Property<?>> T getProperty(String key) {
        return (T)ENTRIES.get(key);
    }

    public static boolean has(String key) {
        return ENTRIES.containsKey(key);
    }

    public static int size() {
        return ENTRIES.size();
    }

    private static int isValidNamespace(String namespace) {
        for (int i = 0; i < namespace.length(); ++i) {
            if (PropertyMap.validNamespaceChar(namespace.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean validNamespaceChar(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    private PropertyMap() {
    }
}

