/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mixin;

import bottomtextdanny.braincell.mod.entity.modules.variable.VariableModule;
import bottomtextdanny.braincell.mod.entity.modules.variable.VariantProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class}, priority=100)
public abstract class MobMixin
extends LivingEntity {
    protected MobMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="HEAD")}, method={"finalizeSpawn"}, remap=true)
    public void finalizeSpawnHook(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroup, CompoundTag tag, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.tryChooseVariant();
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"}, remap=true)
    public void readAdditionalSaveDataHook(CompoundTag tag, CallbackInfo ci) {
        if (!this.f_19853_.m_5776_()) {
            this.tryChooseVariant(tag);
        }
    }

    public void tryChooseVariant() {
        VariantProvider provider;
        MobMixin mobMixin = this;
        if (mobMixin instanceof VariantProvider && (provider = (VariantProvider)((Object)mobMixin)).operatingVariableModule() && !provider.variableModule().appliedChanges()) {
            VariableModule module = provider.variableModule();
            Mob entity = (Mob)this;
            if (!module.isUpdated()) {
                if (!module.hasFormTnput()) {
                    module.setForm(provider.chooseVariant());
                }
                if (module.getForm() == null) {
                    VariantProvider.LOGGER.error("invalid variant choosen for " + entity.m_6095_().getRegistryName() + " at position " + entity.m_20182_());
                } else {
                    boolean fullHealth = entity.m_21223_() == entity.m_21233_();
                    module.getForm().applyAttributeBonusesRaw(entity);
                    if (fullHealth) {
                        entity.m_21153_(entity.m_21233_());
                    }
                }
            }
            module.setAppliedChanges();
        }
    }

    public void tryChooseVariant(CompoundTag tag) {
        VariantProvider provider;
        MobMixin mobMixin = this;
        if (mobMixin instanceof VariantProvider && (provider = (VariantProvider)((Object)mobMixin)).operatingVariableModule() && !provider.variableModule().appliedChanges()) {
            VariableModule module = provider.variableModule();
            Mob entity = (Mob)this;
            if (!module.isUpdated()) {
                if (!module.hasFormTnput()) {
                    module.setForm(provider.chooseVariant());
                }
                if (module.getForm() == null) {
                    VariantProvider.LOGGER.error("invalid variant choosen for " + entity.m_6095_().getRegistryName() + " at position " + entity.m_20182_());
                } else {
                    float health = tag.m_128457_("Health");
                    boolean fullHealth = health == entity.m_21233_() || !tag.m_128441_("Health") || health <= 0.0f;
                    module.getForm().applyAttributeBonusesRaw(entity);
                    if (fullHealth) {
                        entity.m_21153_(entity.m_21233_());
                    } else {
                        entity.m_21153_(health);
                    }
                }
            }
            module.setAppliedChanges();
        }
    }
}

