/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mixin;

import bottomtextdanny.braincell.mod.entity.modules.animatable.BaseAnimatableModule;
import bottomtextdanny.braincell.mod.entity.modules.animatable.BaseAnimatableProvider;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManagerProvider;
import bottomtextdanny.braincell.mod.entity.modules.looped_walk.LoopedWalkProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    private boolean injectedMovementOnTravel;

    @Inject(at={@At(value="TAIL")}, method={"tick"}, remap=true)
    public void tickHook(CallbackInfo ci) {
        BaseAnimatableProvider provider;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof BaseAnimatableProvider && (provider = (BaseAnimatableProvider)((Object)entityMixin)).operateAnimatableModule()) {
            ((BaseAnimatableModule)provider.animatableModule()).tick();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"playStepSound"}, remap=true, cancellable=true)
    public void cancelStepSound(BlockPos positionBelow, BlockState blockStateBelow, CallbackInfo ci) {
        LoopedWalkProvider provider;
        Entity entity = (Entity)this;
        if (entity instanceof LoopedWalkProvider && (provider = (LoopedWalkProvider)entity).operateWalkModule()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"playAmethystStepSound"}, remap=true, cancellable=true)
    public void cancelAmethystStepSound(BlockState blockStateBelow, CallbackInfo ci) {
        LoopedWalkProvider provider;
        Entity entity = (Entity)this;
        if (entity instanceof LoopedWalkProvider && (provider = (LoopedWalkProvider)entity).operateWalkModule()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.BEFORE)}, method={"saveWithoutId"}, remap=true)
    public void preSaveExtraHook(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof BCDataManagerProvider) {
            BCDataManagerProvider provider = (BCDataManagerProvider)((Object)entityMixin);
            provider.bcDataManager().writeTag(tag);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setYBodyRot(F)V", shift=At.Shift.BEFORE)}, method={"load"}, remap=true)
    public void preLoadExtraHook(CompoundTag tag, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof BCDataManagerProvider) {
            BCDataManagerProvider provider = (BCDataManagerProvider)((Object)entityMixin);
            provider.bcDataManager().readTag(tag);
        }
    }
}

