/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.base.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableBoolean;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Lazy<T>
implements Supplier<T> {
    protected T value;

    private Lazy() {
    }

    public static <T> Lazy<T> of(Supplier<T> provider) {
        return new Normal<T>(provider);
    }

    public static <T> Lazy<T> failNull(Supplier<T> provider) {
        return new FailNull<T>(provider);
    }

    public static <T> Lazy<T> failable(Function<MutableBoolean, T> provider) {
        return new Failable<T>(provider);
    }

    @Override
    public T get() {
        return this.isBuilt() ? this.value : this.build();
    }

    protected abstract T build();

    public abstract boolean isBuilt();

    private static final class Normal<T>
    extends Lazy<T> {
        private Supplier<T> provider;

        public Normal(Supplier<T> provider) {
            this.provider = provider;
        }

        @Override
        protected T build() {
            this.value = this.provider.get();
            this.provider = null;
            return (T)this.value;
        }

        @Override
        public boolean isBuilt() {
            return this.provider == null;
        }
    }

    private static final class FailNull<T>
    extends Lazy<T> {
        private Supplier<T> provider;

        public FailNull(Supplier<T> provider) {
            this.provider = provider;
        }

        @Override
        protected T build() {
            this.value = this.provider.get();
            if (this.value == null) {
                this.provider = null;
            }
            return (T)this.value;
        }

        @Override
        public boolean isBuilt() {
            return this.provider == null;
        }
    }

    private static final class Failable<T>
    extends Lazy<T> {
        private Function<MutableBoolean, T> provider;
        private MutableBoolean valid = new MutableBoolean();

        public Failable(Function<MutableBoolean, T> provider) {
            this.provider = provider;
        }

        @Override
        protected T build() {
            this.valid.setTrue();
            this.value = this.provider.apply(this.valid);
            if (this.valid.isFalse()) {
                this.valid = null;
                this.provider = null;
            }
            return (T)this.value;
        }

        @Override
        public boolean isBuilt() {
            return this.provider == null;
        }
    }
}

