/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.base;

import bottomtextdanny.braincell.base.pair.IntPair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

public final class WeightArray<T> {
    public final int itemSize;
    public final int weightArraySizeSize;
    private final T[] elementArray;

    private WeightArray(Class<T> clazz, Collection<IntPair<T>> items, int totalWeight) {
        this.itemSize = items.size();
        this.weightArraySizeSize = totalWeight;
        this.elementArray = (Object[])Array.newInstance(clazz, totalWeight);
        int[] majorPointer = new int[]{0};
        items.forEach(pair -> {
            for (int weightToGo = pair.left().intValue(); weightToGo > 0; --weightToGo) {
                this.elementArray[Math.max((int)(weightToGo + majorPointer[0] - 1), (int)0)] = pair.right();
            }
            majorPointer[0] = majorPointer[0] + pair.left();
        });
    }

    public T mapClamped(int position) {
        return this.map(Math.max(Math.min(position, this.weightArraySizeSize), 0));
    }

    public T map(int positionInbound) {
        return this.elementArray[positionInbound];
    }

    public static class Builder<T> {
        private final ArrayList<IntPair<T>> weightedCollection = new ArrayList(0);
        private int total;
        private final Class<T> itemClazz;

        private Builder(Class<T> clazz) {
            this.itemClazz = clazz;
        }

        public static <T> Builder<T> create(Class<T> clazz) {
            return new Builder<T>(clazz);
        }

        public Builder<T> add(int weight, T element) {
            this.weightedCollection.add(IntPair.of(weight, element));
            this.total += weight;
            return this;
        }

        public WeightArray<T> build() {
            return new WeightArray<T>(this.itemClazz, this.weightedCollection, this.total);
        }
    }
}

