/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.base;

import java.util.random.RandomGenerator;

@FunctionalInterface
public interface FloatRandomPicker {
    public float compute(float var1, float var2, RandomGenerator var3);

    public static FloatRandomPicker linear() {
        return (min, max, random) -> random.nextFloat(min, max);
    }

    public static FloatRandomPicker trapezoid() {
        return (min, max, random) -> {
            float ran = max - min;
            float cen = ran / 2.0f;
            float inv = ran - cen;
            return min + random.nextFloat() * inv + random.nextFloat() * cen;
        };
    }

    public static FloatRandomPicker trapezoid(float plateau) {
        return (min, max, random) -> {
            float ran = max - min;
            float cen = (ran - plateau) / 2.0f;
            float inv = ran - cen;
            return min + random.nextFloat() * inv + random.nextFloat() * cen;
        };
    }

    public static FloatRandomPicker normal() {
        return (min, max, random) -> {
            float mean = (max - min) / 2.0f;
            return min + (float)random.nextGaussian() * mean;
        };
    }
}

