/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.base;

import bottomtextdanny.braincell.base.BCMath;

public interface Easing {
    public static final Easing LINEAR = value -> value;
    public static final Easing EASE_IN_SINE = value -> 1.0f - BCMath.cos((float)((double)value * (Math.PI * 2)));
    public static final Easing EASE_OUT_SINE = value -> BCMath.sin((float)((double)value * (Math.PI * 2)));
    public static final Easing EASE_IN_OUT_SINE = value -> -(BCMath.cos(Math.PI * (double)value) - 1.0f) / 2.0f;
    public static final Easing EASE_IN_SQUARE = value -> value * value;
    public static final Easing EASE_OUT_SQUARE = value -> {
        float inv = 1.0f - value;
        return 1.0f - inv * inv;
    };
    public static final Easing EASE_IN_OUT_SQUARE = value -> {
        if ((double)value < 0.5) {
            return 2.0f * value * value;
        }
        value = -2.0f * value + 2.0f;
        return 1.0f - value * value / 2.0f;
    };
    public static final Easing EASE_IN_CUBIC = value -> value * value * value;
    public static final Easing EASE_OUT_CUBIC = value -> {
        value = 1.0f - value;
        return 1.0f - value * value * value;
    };
    public static final Easing EASE_IN_OUT_CUBIC = value -> {
        if ((double)value < 0.5) {
            return 4.0f * value * value * value;
        }
        value = -2.0f * value + 2.0f;
        return 1.0f - value * value * value / 2.0f;
    };
    public static final Easing EASE_IN_QUART = value -> value * value * value * value;
    public static final Easing EASE_OUT_QUART = value -> {
        value = 1.0f - value;
        return 1.0f - value * value * value * value;
    };
    public static final Easing EASE_IN_OUT_QUART = value -> {
        if ((double)value < 0.5) {
            return 8.0f * value * value * value * value;
        }
        value = -2.0f * value + 2.0f;
        return 1.0f - value * value * value * value / 2.0f;
    };
    public static final Easing EASE_IN_QUINT = value -> value * value * value * value * value;
    public static final Easing EASE_OUT_QUINT = value -> {
        value = 1.0f - value;
        return 1.0f - value * value * value * value * value;
    };
    public static final Easing EASE_IN_OUT_QUINT = value -> {
        if ((double)value < 0.5) {
            return 16.0f * value * value * value * value * value;
        }
        value = -2.0f * value + 2.0f;
        return 1.0f - value * value * value * value * value / 2.0f;
    };
    public static final Easing BOUNCE_OUT = value -> {
        double n1 = 7.5625;
        double d1 = 2.75;
        if ((double)value < 1.0 / d1) {
            return (float)(n1 * (double)value * (double)value);
        }
        if ((double)value < 2.0 / d1) {
            value = (float)((double)value - 1.5 / d1);
            return (float)(n1 * (double)value * (double)value + 0.75);
        }
        if ((double)value < 2.5 / d1) {
            value = (float)((double)value - 2.25 / d1);
            return (float)(n1 * (double)value * (double)value + 0.9375);
        }
        value = (float)((double)value - 2.625 / d1);
        return (float)(n1 * (double)value * (double)value + 0.984375);
    };
    public static final Easing BOUNCE_IN = value -> 1.0f - BOUNCE_OUT.progression(value);
    public static final Easing BOUNCE_IN_OUT = value -> value < 0.5f ? (1.0f - BOUNCE_OUT.progression(1.0f - 2.0f * value)) / 2.0f : (1.0f + BOUNCE_OUT.progression(2.0f * value - 1.0f)) / 2.0f;
    public static final Easing EASE_IN_GAMMA = value -> (float)Math.pow(value, 2.2f);
    public static final Easing EASE_OUT_GAMMA = value -> (float)(1.0 - Math.pow(1.0f - value, 2.2f));
    public static final Easing EASE_IN_BACK = value -> {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return (float)(1.0 + c3 * Math.pow(value - 1.0f, 3.0) + c1 * Math.pow(value - 1.0f, 2.0));
    };
    public static final Easing EASE_OUT_BACK = value -> {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return (float)(c3 * (double)value * (double)value * (double)value - c1 * (double)value * (double)value);
    };

    public float progression(float var1);
}

