/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.base;

import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.random.RandomGenerator;

public class Chooser<T> {
    private final NavigableMap<Float, T> weightTable;
    private final float total;

    private Chooser(NavigableMap<Float, T> weightTable, float total) {
        this.weightTable = weightTable;
        this.total = total;
    }

    public Chooser(NavigableMap<Float, T> weightTable) {
        float total = 0.0f;
        for (Float weight : weightTable.keySet()) {
            total += weight.floatValue();
        }
        this.weightTable = weightTable;
        this.total = total;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public T pick(RandomGenerator chooser) {
        return this.weightTable.higherEntry(Float.valueOf(this.total * chooser.nextFloat())).getValue();
    }

    public void fillArray(T[] array, RandomGenerator chooser) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.weightTable.higherEntry(Float.valueOf(this.total * chooser.nextFloat())).getValue();
        }
    }

    public static final class Builder<T> {
        private final NavigableMap<Float, T> weightTable = new TreeMap<Float, T>();
        private float total;

        private Builder() {
        }

        public Builder<T> put(float weight, T item) {
            if (weight <= 0.0f) {
                return this;
            }
            this.total += weight;
            this.weightTable.put(Float.valueOf(this.total), item);
            return this;
        }

        public Chooser<T> build() {
            return new Chooser<T>(this.weightTable, this.total);
        }
    }
}

