/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;

class PlanarQuadRenderer {
    PlanarQuadRenderer() {
    }

    static Vector3f getOffsetFor(Direction facing, double x, double y, double z, int layer) {
        return PlanarQuadRenderer.getOffsetFor(facing, (float)x, (float)y, (float)z, layer);
    }

    private static Vector3f getOffsetFor(Direction facing, float x, float y, float z, int layer) {
        return PlanarQuadRenderer.getOffsetFor(facing, new Vector3f(x, y, z), layer);
    }

    public static Vector3f getOffsetFor(Direction facing, Vector3f vector, int layer) {
        if (layer == 0) {
            return vector;
        }
        switch (facing) {
            case UP: {
                vector.m_122272_(0.0f, PlanarQuadRenderer.offsetLayer(layer), 0.0f);
                break;
            }
            case DOWN: {
                vector.m_122272_(0.0f, PlanarQuadRenderer.offsetLayer(-layer), 0.0f);
                break;
            }
            case NORTH: {
                vector.m_122272_(0.0f, 0.0f, PlanarQuadRenderer.offsetLayer(-layer));
                break;
            }
            case SOUTH: {
                vector.m_122272_(0.0f, 0.0f, PlanarQuadRenderer.offsetLayer(layer));
                break;
            }
            case EAST: {
                vector.m_122272_(PlanarQuadRenderer.offsetLayer(layer), 0.0f, 0.0f);
                break;
            }
            case WEST: {
                vector.m_122272_(PlanarQuadRenderer.offsetLayer(-layer), 0.0f, 0.0f);
            }
        }
        return vector;
    }

    private static float offsetLayer(int layer) {
        return 0.001f * (float)layer;
    }

    static Vector3f[] getQuadsFor(Direction facing) {
        if (facing != null) {
            switch (facing) {
                case DOWN: {
                    return new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f)};
                }
                case NORTH: {
                    return new Vector3f[]{new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)};
                }
                case SOUTH: {
                    return new Vector3f[]{new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)};
                }
                case EAST: {
                    return new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)};
                }
                case WEST: {
                    return new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
                }
            }
            return new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
        }
        return new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
    }
}

