/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KillTask
extends Task {
    public static final ResourceLocation ZOMBIE = new ResourceLocation("minecraft:zombie");
    public ResourceLocation entity = ZOMBIE;
    public long value = 100L;

    public KillTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("entity", this.entity.toString());
        nbt.m_128356_("value", this.value);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.entity = new ResourceLocation(nbt.m_128461_("entity"));
        this.value = nbt.m_128454_("value");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.entity.toString(), Short.MAX_VALUE);
        buffer.m_130103_(this.value);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.entity = new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE));
        this.value = buffer.m_130242_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ArrayList ids = new ArrayList(Registry.f_122826_.m_6566_());
        config.addEnum("entity", (Object)this.entity, v -> {
            this.entity = v;
        }, NameMap.of((Object)ZOMBIE, ids).nameKey(v -> "entity." + v.m_135827_() + "." + v.m_135815_()).icon(v -> {
            SpawnEggItem item = SpawnEggItem.m_43213_((EntityType)((EntityType)Registry.f_122826_.m_7745_(v)));
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.f_42007_));
        }).create(), (Object)ZOMBIE);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return new TranslatableComponent("ftbquests.task.ftbquests.kill.title", new Object[]{this.formatMaxProgress(), new TranslatableComponent("entity." + this.entity.m_135827_() + "." + this.entity.m_135815_())});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        SpawnEggItem item = SpawnEggItem.m_43213_((EntityType)((EntityType)Registry.f_122826_.m_7745_(this.entity)));
        return ItemIcon.getItemIcon((Item)(item != null ? item : Items.f_42007_));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void kill(TeamData teamData, LivingEntity e) {
        if (!teamData.isCompleted(this) && this.entity.equals((Object)Registries.getId((Object)e.m_6095_(), (ResourceKey)Registry.f_122903_))) {
            teamData.addProgress(this, 1L);
        }
    }
}

