/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.stages;

import dev.ftb.mods.ftbquests.quest.task.StageTask;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;

public class GameStagesEventHandler {
    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(GameStagesEventHandler::onStageAdded);
        MinecraftForge.EVENT_BUS.addListener(GameStagesEventHandler::onStageRemoved);
        MinecraftForge.EVENT_BUS.addListener(GameStagesEventHandler::onStagesCleared);
    }

    private static void onStageAdded(GameStageEvent.Added event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            StageTask.checkStages(sp);
        }
    }

    private static void onStageRemoved(GameStageEvent.Removed event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            StageTask.checkStages(sp);
        }
    }

    private static void onStagesCleared(GameStageEvent.Cleared event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            StageTask.checkStages(sp);
        }
    }
}

