/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.gui.IRewardListenerScreen;
import dev.ftb.mods.ftbquests.gui.RewardKey;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RewardNotificationsScreen
extends BaseScreen
implements IRewardListenerScreen {
    public final Object2IntOpenHashMap<RewardKey> rewards = new Object2IntOpenHashMap();
    private final SimpleTextButton closeButton = new SimpleTextButton((Panel)this, (Component)new TranslatableComponent("gui.close"), (Icon)Icon.EMPTY){

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.getGui().closeGui();
        }
    };
    private final Panel itemPanel = new Panel((Panel)this){

        public void addWidgets() {
            ArrayList keys = new ArrayList(RewardNotificationsScreen.this.rewards.keySet());
            keys.sort((o1, o2) -> Integer.compare(RewardNotificationsScreen.this.rewards.getInt(o2), RewardNotificationsScreen.this.rewards.getInt(o1)));
            for (RewardKey key : keys) {
                this.add(new RewardNotification(this, key));
            }
        }

        public void alignWidgets() {
            if (this.widgets.size() < 9) {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(0, 1, 0)));
                this.setHeight(22);
            } else {
                this.setWidth(207);
                this.setHeight(23 * Mth.m_14167_((float)((float)this.widgets.size() / 9.0f)));
                for (int i = 0; i < this.widgets.size(); ++i) {
                    ((Widget)this.widgets.get(i)).setPos(i % 9 * 23, i / 9 * 23);
                }
            }
            this.setPos((RewardNotificationsScreen.this.width - RewardNotificationsScreen.this.itemPanel.width) / 2, (RewardNotificationsScreen.this.height - RewardNotificationsScreen.this.itemPanel.height) / 2);
        }
    };

    public RewardNotificationsScreen() {
        this.itemPanel.setOnlyRenderWidgetsInside(false);
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.closeButton);
        this.closeButton.setPos((this.width - this.closeButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((int)((double)w / 2.0)), (double)((int)((double)h / 5.0)), 0.0);
        matrixStack.m_85841_(2.0f, 2.0f, 1.0f);
        TranslatableComponent s = new TranslatableComponent("ftbquests.rewards");
        theme.drawString(matrixStack, (Object)s, (float)(-theme.getStringWidth((FormattedText)s)) / 2.0f, 0.0f, Color4I.WHITE, 0);
        matrixStack.m_85849_();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    @Override
    public void rewardReceived(RewardKey key, int count) {
        this.rewards.put((Object)key, this.rewards.getInt((Object)key) + count);
        this.itemPanel.refreshWidgets();
    }

    private class RewardNotification
    extends Widget {
        private final RewardKey key;

        public RewardNotification(Panel p, RewardKey e) {
            super(p);
            this.setSize(22, 22);
            this.key = e;
        }

        public void addMouseOverText(TooltipList list) {
            if (!this.key.title.isEmpty()) {
                list.string(this.key.title);
            }
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get((String)"rsquare").outline.draw(matrixStack, x, y, w, h);
            this.key.icon.draw(matrixStack, x + 3, y + 3, 16, 16);
            int count = RewardNotificationsScreen.this.rewards.getInt((Object)this.key);
            if (count > 1) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.0, 600.0);
                MutableComponent s = new TextComponent(StringUtils.formatDouble((double)count, (boolean)true)).m_130940_(ChatFormatting.YELLOW);
                theme.drawString(matrixStack, (Object)s, x + 22 - theme.getStringWidth((FormattedText)s), y + 12, 2);
                matrixStack.m_85849_();
            }
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient(this.key.icon.getIngredient()).tooltip();
        }
    }
}

