/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class MultilineTextEditorScreen
extends BaseScreen {
    public final ListConfig<String, StringConfig> config;
    public final ConfigCallback callback;
    public List<EntryTextBox> textBoxes;
    public int active = 0;

    public MultilineTextEditorScreen(ListConfig<String, StringConfig> c, ConfigCallback ca) {
        this.config = c;
        this.callback = ca;
        this.textBoxes = new ArrayList<EntryTextBox>();
        for (String s : (List)c.value) {
            EntryTextBox box = new EntryTextBox((Panel)this);
            box.setText(s);
            this.textBoxes.add(box);
        }
        if (this.textBoxes.isEmpty()) {
            this.textBoxes.add(new EntryTextBox((Panel)this));
        }
        this.textBoxes.get(0).setFocused(true);
        this.reIndexTextBoxes();
    }

    public boolean onInit() {
        this.setWidth(this.getScreen().m_85445_() / 5 * 4);
        return true;
    }

    public void addWidgets() {
        this.add((Widget)new TextField((Panel)this).setText((Component)new TranslatableComponent("ftbquests.gui.edit_description")));
        ((Widget)this.widgets.get(0)).setPos((this.width - ((Widget)this.widgets.get((int)0)).width) / 2, -this.getTheme().getFontHeight() - 2);
        this.add((Widget)new TextField((Panel)this).setText((Component)new TranslatableComponent("ftbquests.gui.edit_description.help").m_130940_(ChatFormatting.GRAY)));
        ((Widget)this.widgets.get(1)).setPos((this.width - ((Widget)this.widgets.get((int)1)).width) / 2, this.height + 5);
        this.add(new SimpleButton((Panel)this, (Component)new TranslatableComponent("gui.accept"), Icons.ACCEPT, (simpleButton, mouseButton) -> this.saveAndExit()).setPosAndSize(this.width + 6, 6, 16, 16));
        this.add(new SimpleButton((Panel)this, (Component)new TranslatableComponent("gui.cancel"), Icons.CANCEL, (simpleButton, mouseButton) -> this.cancel()).setPosAndSize(this.width + 6, 24, 16, 16));
        for (int i = 0; i < this.textBoxes.size(); ++i) {
            this.textBoxes.get(i).setPosAndSize(2, 2 + i * 12, this.width - 4, 12);
        }
        this.addAll(this.textBoxes);
    }

    private void cancel() {
        this.callback.save(false);
    }

    private void saveAndExit() {
        ((List)this.config.value).clear();
        for (TextBox textBox : this.textBoxes) {
            ((List)this.config.value).add(textBox.getText());
        }
        this.closeGui();
        this.callback.save(true);
    }

    private void reIndexTextBoxes() {
        for (int i = 0; i < this.textBoxes.size(); ++i) {
            this.textBoxes.get((int)i).index = i;
        }
    }

    private void unfocusAll() {
        for (TextBox textBox : this.textBoxes) {
            textBox.setFocused(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean keyPressed(Key key) {
        if (key.is(257)) {
            if (MultilineTextEditorScreen.isShiftKeyDown()) {
                this.saveAndExit();
                return super.keyPressed(key);
            }
            this.unfocusAll();
            ++this.active;
            this.textBoxes.add(this.active, new EntryTextBox((Panel)this));
            this.textBoxes.get(this.active).setFocused(true);
            this.reIndexTextBoxes();
            this.refreshWidgets();
            return true;
        }
        if (key.is(259)) {
            if (this.active <= 0) return super.keyPressed(key);
            if (!this.textBoxes.get(this.active).getText().isEmpty()) return super.keyPressed(key);
            this.unfocusAll();
            this.textBoxes.remove(this.active);
            --this.active;
            this.textBoxes.get(this.active).setFocused(true);
            this.reIndexTextBoxes();
            this.refreshWidgets();
            return true;
        }
        if (key.is(265)) {
            if (this.active <= 0) return super.keyPressed(key);
            this.unfocusAll();
            --this.active;
            this.textBoxes.get(this.active).setFocused(true);
            this.textBoxes.get(this.active).setCursorPosition(this.textBoxes.get(this.active + 1).getCursorPosition());
            return true;
        }
        if (key.is(264)) {
            if (this.active >= this.textBoxes.size() - 1) return super.keyPressed(key);
            this.unfocusAll();
            ++this.active;
            this.textBoxes.get(this.active).setFocused(true);
            this.textBoxes.get(this.active).setCursorPosition(this.textBoxes.get(this.active - 1).getCursorPosition());
            return true;
        }
        if (!key.esc()) return super.keyPressed(key);
        this.callback.save(false);
        return super.keyPressed(key);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class EntryTextBox
    extends TextBox {
        private int index;

        public EntryTextBox(Panel panel) {
            super(panel);
        }

        public boolean mousePressed(MouseButton button) {
            for (TextBox textBox : MultilineTextEditorScreen.this.textBoxes) {
                if (textBox == this) continue;
                textBox.setFocused(false);
            }
            MultilineTextEditorScreen.this.active = this.index;
            return super.mousePressed(button);
        }
    }
}

