/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.util.TextUtils;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;

public class ClientQuestFile
extends QuestFile {
    public static ClientQuestFile INSTANCE;
    public TeamData self;
    public QuestScreen questScreen;
    public BaseScreen questGui;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    @Override
    public void load() {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        this.self = new TeamData(Util.f_137441_);
        this.self.file = this;
        this.self.name = "Loading...";
        this.self.setLocked(true);
        INSTANCE = this;
        this.refreshGui();
        FTBQuestsJEIHelper.refresh(this);
    }

    @Override
    public boolean canEdit() {
        return this.self.getCanEdit();
    }

    @Override
    public void refreshGui() {
        this.clearCachedData();
        boolean hasPrev = false;
        boolean guiOpen = false;
        int zoom = 0;
        double scrollX = 0.0;
        double scrollY = 0.0;
        long selectedChapter = 0L;
        long[] selectedQuests = new long[]{};
        boolean chaptersExpanded = false;
        if (this.questScreen != null) {
            hasPrev = true;
            zoom = this.questScreen.zoom;
            scrollX = this.questScreen.questPanel.centerQuestX;
            scrollY = this.questScreen.questPanel.centerQuestY;
            selectedChapter = this.questScreen.selectedChapter == null ? 0L : this.questScreen.selectedChapter.id;
            selectedQuests = new long[this.questScreen.selectedObjects.size()];
            int i = 0;
            for (Movable m : this.questScreen.selectedObjects) {
                selectedQuests[i] = m.getMovableID();
                ++i;
            }
            if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != null) {
                guiOpen = true;
            }
            chaptersExpanded = this.questScreen.chapterPanel.expanded;
        }
        Minecraft.m_91087_().m_91152_(null);
        this.questScreen = new QuestScreen(this);
        this.questGui = this.questScreen;
        if (hasPrev) {
            this.questScreen.zoom = zoom;
            this.questScreen.selectChapter(this.getChapter(selectedChapter));
            for (long id : selectedQuests) {
                QuestObject questObject = this.get(id);
                if (!(questObject instanceof Movable)) continue;
                Movable m = (Movable)((Object)questObject);
                this.questScreen.selectedObjects.add(m);
            }
            if (guiOpen) {
                this.questScreen.openGui();
            }
        }
        this.questScreen.refreshWidgets();
        if (hasPrev) {
            this.questScreen.questPanel.scrollTo(scrollX, scrollY);
        }
        this.questScreen.chapterPanel.setExpanded(chaptersExpanded);
    }

    public void openQuestGui() {
        if (ClientQuestFile.exists()) {
            if (this.disableGui && !this.canEdit()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new CustomToast((Component)new TranslatableComponent("item.ftbquests.book.disabled"), Icons.BARRIER, TextComponent.f_131282_));
            } else if (this.self.isLocked()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new CustomToast((Component)(this.lockMessage.isEmpty() ? new TextComponent("Quests locked!") : TextUtils.parseRawText(this.lockMessage)), Icons.BARRIER, TextComponent.f_131282_));
            } else {
                this.questGui.openGui();
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.CLIENT;
    }

    @Override
    public void deleteObject(long id) {
        new DeleteObjectMessage(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }

    @Override
    public TeamData getData(Entity player) {
        return player == Minecraft.m_91087_().f_91074_ ? this.self : this.getData(Objects.requireNonNull(ClientTeamManager.INSTANCE.getKnownPlayer((UUID)player.m_142081_()), (String)"Non-null team required!").teamId);
    }

    public static void openBookToQuestObject(long id) {
        if (ClientQuestFile.exists()) {
            ClientQuestFile file = INSTANCE;
            if (file.questScreen == null) {
                INSTANCE.openQuestGui();
            }
            if (file.questScreen != null) {
                if (id != 0L) {
                    QuestObject qo = file.get(id);
                    if (qo != null) {
                        file.questScreen.open(qo, true);
                    }
                } else {
                    file.questScreen.openGui();
                }
            }
        }
    }
}

