/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.flushconsolidation;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import me.steinborn.krypton.mod.shared.network.ConfigurableAutoFlush;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Connection.class})
public abstract class ClientConnectionMixin
implements ConfigurableAutoFlush {
    @Shadow
    private Channel f_129468_;
    private AtomicBoolean autoFlush;

    @Shadow
    public abstract void m_129498_(ConnectionProtocol var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddedFields(CallbackInfo ci) {
        this.autoFlush = new AtomicBoolean(true);
    }

    @Inject(locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, method={"sendImmediately"}, at={@At(value="FIELD", target="Lnet/minecraft/network/ClientConnection;packetsSentCounter:I", opcode=181, shift=At.Shift.AFTER)})
    private void sendImmediately$rewrite(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, CallbackInfo info, ConnectionProtocol packetState, ConnectionProtocol protocolState) {
        boolean newState;
        boolean bl = newState = packetState != protocolState;
        if (this.f_129468_.eventLoop().inEventLoop()) {
            if (newState) {
                this.m_129498_(packetState);
            }
            this.doSendPacket(packet, callback);
        } else if (!newState && callback == null) {
            ChannelPromise voidPromise = this.f_129468_.voidPromise();
            if (this.autoFlush.get()) {
                this.f_129468_.writeAndFlush(packet, voidPromise);
            } else {
                this.f_129468_.write(packet, voidPromise);
            }
        } else {
            if (newState) {
                this.f_129468_.config().setAutoRead(false);
            }
            this.f_129468_.eventLoop().execute(() -> {
                if (newState) {
                    this.m_129498_(packetState);
                }
                this.doSendPacket(packet, callback);
            });
        }
        info.cancel();
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/network/ClientConnection;channel:Lio/netty/channel/Channel;", opcode=180))
    public Channel disableForcedFlushEveryTick(Connection clientConnection) {
        return null;
    }

    private void doSendPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        if (callback == null) {
            this.f_129468_.write(packet, this.f_129468_.voidPromise());
        } else {
            ChannelFuture channelFuture = this.f_129468_.write(packet);
            channelFuture.addListener(callback);
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        if (this.autoFlush.get()) {
            this.f_129468_.flush();
        }
    }

    @Override
    public void setShouldAutoFlush(boolean shouldAutoFlush) {
        boolean prev = this.autoFlush.getAndSet(shouldAutoFlush);
        if (!prev && shouldAutoFlush) {
            this.f_129468_.flush();
        }
    }
}

