/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.sonicether.soundphysics.SoundPhysicsMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;

public class RaycastRenderer {
    private static final List<Ray> rays = Collections.synchronizedList(new ArrayList());
    private static final Minecraft mc = Minecraft.m_91087_();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderRays(double x, double y, double z) {
        if (RaycastRenderer.mc.f_91073_ == null) {
            return;
        }
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue() && !SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            List<Ray> list = rays;
            synchronized (list) {
                rays.clear();
            }
            return;
        }
        long gameTime = RaycastRenderer.mc.f_91073_.m_46467_();
        List<Ray> list = rays;
        synchronized (list) {
            rays.removeIf(ray -> gameTime - ray.tickCreated > ray.lifespan || gameTime - ray.tickCreated < 0L);
            for (Ray ray2 : rays) {
                RaycastRenderer.renderRay(ray2, x, y, z);
            }
        }
    }

    public static void addSoundBounceRay(Vec3 start, Vec3 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, false);
    }

    public static void addOcclusionRay(Vec3 start, Vec3 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRay(Vec3 start, Vec3 end, int color, boolean throughWalls) {
        if (RaycastRenderer.mc.f_91074_.m_20182_().m_82554_(start) > 32.0 && RaycastRenderer.mc.f_91074_.m_20182_().m_82554_(end) > 32.0) {
            return;
        }
        List<Ray> list = rays;
        synchronized (list) {
            rays.add(new Ray(start, end, color, throughWalls));
        }
    }

    public static void renderRay(Ray ray, double x, double y, double z) {
        int red = RaycastRenderer.getRed(ray.color);
        int green = RaycastRenderer.getGreen(ray.color);
        int blue = RaycastRenderer.getBlue(ray.color);
        if (!ray.throughWalls) {
            RenderSystem.m_69482_();
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        RenderSystem.m_69832_((float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(ray.start.f_82479_ - x, ray.start.f_82480_ - y, ray.start.f_82481_ - z).m_6122_(red, green, blue, 255).m_5752_();
        bufferBuilder.m_5483_(ray.end.f_82479_ - x, ray.end.f_82480_ - y, ray.end.f_82481_ - z).m_6122_(red, green, blue, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
    }

    private static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    private static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    private static int getBlue(int argb) {
        return argb & 0xFF;
    }

    private static class Ray {
        private final Vec3 start;
        private final Vec3 end;
        private final int color;
        private final long tickCreated;
        private final long lifespan;
        private final boolean throughWalls;

        public Ray(Vec3 start, Vec3 end, int color, boolean throughWalls) {
            this.start = start;
            this.end = end;
            this.color = color;
            this.throughWalls = throughWalls;
            this.tickCreated = RaycastRenderer.mc.f_91073_.m_46467_();
            this.lifespan = 40L;
        }
    }
}

